/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.model.impl.SegmentsExperimentImpl;
import com.liferay.segments.service.persistence.SegmentsExperimentFinder;
import com.liferay.segments.service.persistence.impl.SegmentsExperimentFinderBaseImpl;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SegmentsExperimentFinder.class})
public class SegmentsExperimentFinderImpl
extends SegmentsExperimentFinderBaseImpl
implements SegmentsExperimentFinder {
    public static final String COUNT_BY_S_C_C_S = SegmentsExperimentFinder.class.getName() + ".countByS_C_C_S";
    public static final String FIND_BY_S_C_C_S = SegmentsExperimentFinder.class.getName() + ".findByS_C_C_S";
    @Reference
    private CustomSQL _customSQL;

    public int countByS_C_C_S(long segmentsExperienceId, long classNameId, long classPK, int[] statuses) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_S_C_C_S);
            sql = StringUtil.replace((String)sql, (String)"[$STATUSES$]", (String)this.getStatusesSQL(statuses));
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(segmentsExperienceId);
            qPos.add(classNameId);
            qPos.add(classPK);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SegmentsExperiment> findByS_C_C_S(long segmentsExperienceId, long classNameId, long classPK, int[] statuses, int start, int end, OrderByComparator<SegmentsExperiment> orderByComparator) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_S_C_C_S);
            sql = StringUtil.replace((String)sql, (String)"[$STATUSES$]", (String)this.getStatusesSQL(statuses));
            sql = this._customSQL.replaceOrderBy(sql, orderByComparator);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("SegmentsExperiment", SegmentsExperimentImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(segmentsExperienceId);
            qPos.add(classNameId);
            qPos.add(classPK);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getStatusesSQL(int[] statuses) {
        if (ArrayUtil.isEmpty((int[])statuses)) {
            return "";
        }
        StringBundler sb = new StringBundler();
        sb.append("AND SegmentsExperiment.status IN ");
        sb.append("(");
        for (int status : statuses) {
            sb.append(status);
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        return sb.toString();
    }
}

