/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.security.permission.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.contributor.RoleCollection;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.internal.configuration.SegmentsServiceConfiguration;
import com.liferay.segments.model.SegmentsEntryRole;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.service.SegmentsEntryRoleLocalService;
import com.liferay.segments.simulator.SegmentsEntrySimulator;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.segments.internal.configuration.SegmentsServiceConfiguration"}, service={})
public class SegmentsEntryRoleContributor
implements RoleContributor {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryRoleContributor.class);
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;
    @Reference
    private SegmentsEntryRoleLocalService _segmentsEntryRoleLocalService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private volatile SegmentsEntrySimulator _segmentsEntrySimulator;
    private ServiceRegistration<RoleContributor> _serviceRegistration;

    public void contribute(RoleCollection roleCollection) {
        for (long segmentsEntryId : this._getSegmentsEntryIds(roleCollection)) {
            List segmentsEntryRoles = this._segmentsEntryRoleLocalService.getSegmentsEntryRoles(segmentsEntryId);
            for (SegmentsEntryRole segmentsEntryRole : segmentsEntryRoles) {
                roleCollection.addRoleId(segmentsEntryRole.getRoleId());
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        SegmentsServiceConfiguration segmentsServiceConfiguration = (SegmentsServiceConfiguration)ConfigurableUtil.createConfigurable(SegmentsServiceConfiguration.class, properties);
        if (segmentsServiceConfiguration.roleSegmentationEnabled()) {
            this._serviceRegistration = bundleContext.registerService(RoleContributor.class, (Object)this, (Dictionary)new HashMapDictionary());
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private long[] _getSegmentsEntryIds(RoleCollection roleCollection) {
        User user;
        long[] segmentsEntryIds;
        HttpServletRequest httpServletRequest;
        block8: {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (serviceContext == null) {
                return new long[0];
            }
            httpServletRequest = serviceContext.getRequest();
            if (httpServletRequest == null) {
                return new long[0];
            }
            segmentsEntryIds = (long[])httpServletRequest.getAttribute("SEGMENTS_ENTRY_IDS");
            if (segmentsEntryIds != null) {
                return segmentsEntryIds;
            }
            user = roleCollection.getUser();
            if (this._segmentsEntrySimulator != null && this._segmentsEntrySimulator.isSimulationActive(user.getUserId())) {
                segmentsEntryIds = this._segmentsEntrySimulator.getSimulatedSegmentsEntryIds(user.getUserId());
            } else {
                try {
                    segmentsEntryIds = this._segmentsEntryProviderRegistry.getSegmentsEntryIds(roleCollection.getGroupId(), User.class.getName(), user.getUserId(), this._requestContextMapper.map(httpServletRequest));
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)portalException.getMessage());
                }
            }
        }
        if (segmentsEntryIds.length > 0 && _log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Found segments ", segmentsEntryIds, " for user ", user.getUserId(), " in group ", roleCollection.getGroupId()}));
        }
        httpServletRequest.setAttribute("SEGMENTS_ENTRY_IDS", (Object)segmentsEntryIds);
        return segmentsEntryIds;
    }
}

