/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.provider;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.segments.context.Context;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.provider.SegmentsEntryProvider;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.service.SegmentsEntryLocalService;
import java.util.HashSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SegmentsEntryProviderRegistry.class})
public class SegmentsEntryProviderRegistryImpl
implements SegmentsEntryProviderRegistry {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryProviderRegistryImpl.class);
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    private ServiceTrackerMap<String, SegmentsEntryProvider> _serviceTrackerMap;

    public long[] getSegmentsEntryClassPKs(long segmentsEntryId, int start, int end) throws PortalException {
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.getSegmentsEntry(segmentsEntryId);
        SegmentsEntryProvider segmentsEntryProvider = this.getSegmentsEntryProvider(segmentsEntry.getSource());
        if (segmentsEntryProvider == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No segments entry provider found for source " + segmentsEntry.getSource()));
            }
            return new long[0];
        }
        return segmentsEntryProvider.getSegmentsEntryClassPKs(segmentsEntryId, start, end);
    }

    public int getSegmentsEntryClassPKsCount(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.getSegmentsEntry(segmentsEntryId);
        SegmentsEntryProvider segmentsEntryProvider = this.getSegmentsEntryProvider(segmentsEntry.getSource());
        if (segmentsEntryProvider == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No segments entry provider found for source " + segmentsEntry.getSource()));
            }
            return 0;
        }
        return segmentsEntryProvider.getSegmentsEntryClassPKsCount(segmentsEntryId);
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK, Context context) throws PortalException {
        HashSet<Long> segmentsEntryIds = new HashSet<Long>();
        for (SegmentsEntryProvider segmentsEntryProvider : this._serviceTrackerMap.values()) {
            long[] segmentsEntryProviderSegmentsEntryIds;
            for (long segmentsEntryId : segmentsEntryProviderSegmentsEntryIds = segmentsEntryProvider.getSegmentsEntryIds(groupId, className, classPK, context)) {
                segmentsEntryIds.add(segmentsEntryId);
            }
        }
        return ArrayUtil.toLongArray(segmentsEntryIds);
    }

    public SegmentsEntryProvider getSegmentsEntryProvider(String source) {
        return (SegmentsEntryProvider)this._serviceTrackerMap.getService((Object)source);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, SegmentsEntryProvider.class, (String)"segments.entry.provider.source");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

