/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.search;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchResultPermissionFilter;
import com.liferay.portal.kernel.search.SearchResultPermissionFilterFactory;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.segments.odata.search.ODataSearchAdapter;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ODataSearchAdapter.class})
public class ODataSearchAdapterImpl
implements ODataSearchAdapter {
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private SearchResultPermissionFilterFactory _searchResultPermissionFilterFactory;

    public Hits search(long companyId, FilterParser filterParser, String filterString, String className, EntityModel entityModel, Locale locale, int start, int end) throws PortalException {
        try {
            SearchContext searchContext = this._createSearchContext(companyId, start, end);
            Query query = this._getQuery(filterString, className, entityModel, filterParser, locale, searchContext);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker == null) {
                return IndexSearcherHelperUtil.search((SearchContext)searchContext, (Query)query);
            }
            if (searchContext.getUserId() == 0L) {
                searchContext.setUserId(permissionChecker.getUserId());
            }
            SearchResultPermissionFilter searchResultPermissionFilter = this._searchResultPermissionFilterFactory.create(searchContext2 -> IndexSearcherHelperUtil.search((SearchContext)searchContext2, (Query)query), permissionChecker);
            return searchResultPermissionFilter.search(searchContext);
        }
        catch (Exception exception) {
            throw new PortalException("Unable to search with filter " + filterString, (Throwable)exception);
        }
    }

    public int searchCount(long companyId, FilterParser filterParser, String filterString, String className, EntityModel entityModel, Locale locale) throws PortalException {
        try {
            SearchContext searchContext = this._createSearchContext(companyId, 0, 0);
            Query query = this._getQuery(filterString, className, entityModel, filterParser, locale, searchContext);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker == null) {
                return (int)IndexSearcherHelperUtil.searchCount((SearchContext)searchContext, (Query)query);
            }
            if (searchContext.getUserId() == 0L) {
                searchContext.setUserId(permissionChecker.getUserId());
            }
            SearchResultPermissionFilter searchResultPermissionFilter = this._searchResultPermissionFilterFactory.create(searchContext2 -> IndexSearcherHelperUtil.search((SearchContext)searchContext2, (Query)query), permissionChecker);
            Hits hits = searchResultPermissionFilter.search(searchContext);
            return hits.getLength();
        }
        catch (Exception exception) {
            throw new PortalException("Unable to search with filter " + filterString, (Throwable)exception);
        }
    }

    private SearchContext _createSearchContext(long companyId, int start, int end) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{-1L});
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private Query _getQuery(String filterString, String className, EntityModel entityModel, FilterParser filterParser, Locale locale, SearchContext searchContext) throws Exception {
        Indexer indexer = this._indexerRegistry.getIndexer(className);
        BooleanQuery booleanQuery = indexer.getFullQuery(searchContext);
        Filter searchFilter = this._getSearchFilter(filterString, entityModel, filterParser, locale);
        if (searchFilter != null) {
            BooleanFilter preBooleanFilter = booleanQuery.getPreBooleanFilter();
            preBooleanFilter.add(searchFilter, BooleanClauseOccur.MUST);
        }
        return booleanQuery;
    }

    private Filter _getSearchFilter(String filterString, EntityModel entityModel, FilterParser filterParser, Locale locale) throws ExpressionVisitException {
        com.liferay.portal.odata.filter.Filter filter = new com.liferay.portal.odata.filter.Filter(filterParser.parse(filterString));
        if (filter == com.liferay.portal.odata.filter.Filter.emptyFilter()) {
            return null;
        }
        try {
            return (Filter)this._expressionConvert.convert(filter.getExpression(), locale, entityModel);
        }
        catch (Exception exception) {
            throw new InvalidFilterException("Invalid filter: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

