/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.events;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.internal.configuration.SegmentsServiceConfiguration;
import com.liferay.segments.processor.SegmentsExperienceRequestProcessorRegistry;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.segments.simulator.SegmentsEntrySimulator;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.segments.internal.configuration.SegmentsServiceConfiguration"}, service={})
public class SegmentsServicePreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsServicePreAction.class);
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private volatile SegmentsEntrySimulator _segmentsEntrySimulator;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private SegmentsExperienceRequestProcessorRegistry _segmentsExperienceRequestProcessorRegistry;
    private ServiceRegistration<LifecycleAction> _serviceRegistration;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            this.doRun(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        SegmentsServiceConfiguration segmentsServiceConfiguration = (SegmentsServiceConfiguration)ConfigurableUtil.createConfigurable(SegmentsServiceConfiguration.class, properties);
        if (segmentsServiceConfiguration.segmentationEnabled()) {
            this._serviceRegistration = bundleContext.registerService(LifecycleAction.class, (Object)this, MapUtil.singletonDictionary((Object)"key", (Object)"servlet.service.events.pre"));
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    protected void doRun(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isLifecycleRender()) {
            return;
        }
        Layout layout = themeDisplay.getLayout();
        if (layout == null || layout.isTypeControlPanel()) {
            return;
        }
        long[] segmentsEntryIds = (long[])httpServletRequest.getAttribute("SEGMENTS_ENTRY_IDS");
        if (segmentsEntryIds == null) {
            segmentsEntryIds = this._getSegmentsEntryIds(httpServletRequest, themeDisplay.getScopeGroupId(), themeDisplay.getUserId());
        }
        httpServletRequest.setAttribute("SEGMENTS_ENTRY_IDS", (Object)segmentsEntryIds);
        if (!Objects.equals(layout.getType(), "content")) {
            return;
        }
        httpServletRequest.setAttribute("SEGMENTS_EXPERIENCE_IDS", (Object)this._getSegmentsExperienceIds(httpServletRequest, httpServletResponse, layout.getGroupId(), segmentsEntryIds, this._portal.getClassNameId(Layout.class.getName()), layout.getPlid()));
    }

    private long[] _getSegmentsEntryIds(HttpServletRequest httpServletRequest, long groupId, long userId) {
        long[] segmentsEntryIds;
        block4: {
            segmentsEntryIds = new long[]{};
            if (this._segmentsEntrySimulator != null && this._segmentsEntrySimulator.isSimulationActive(userId)) {
                segmentsEntryIds = this._segmentsEntrySimulator.getSimulatedSegmentsEntryIds(userId);
            } else {
                try {
                    segmentsEntryIds = this._segmentsEntryProviderRegistry.getSegmentsEntryIds(groupId, User.class.getName(), userId, this._requestContextMapper.map(httpServletRequest));
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)portalException.getMessage());
                }
            }
        }
        return ArrayUtil.append((long[])segmentsEntryIds, (long)0L);
    }

    private long[] _getSegmentsExperienceIds(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long groupId, long[] segmentsEntryIds, long classNameId, long classPK) {
        long[] segmentsExperienceIds;
        block2: {
            segmentsExperienceIds = new long[]{};
            try {
                segmentsExperienceIds = this._segmentsExperienceRequestProcessorRegistry.getSegmentsExperienceIds(httpServletRequest, httpServletResponse, groupId, classNameId, classPK, segmentsEntryIds);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)portalException, (Throwable)portalException);
            }
        }
        return ArrayUtil.append((long[])segmentsExperienceIds, (long)0L);
    }
}

