/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.base.SegmentsExperienceServiceBaseImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SegmentsExperienceServiceImpl
extends SegmentsExperienceServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(SegmentsExperienceServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.segments");
    private static volatile ModelResourcePermission<SegmentsExperience> _segmentsExperienceResourcePermission = ModelResourcePermissionFactory.getInstance(SegmentsExperienceServiceImpl.class, (String)"_segmentsExperienceResourcePermission", SegmentsExperience.class);

    public SegmentsExperience addSegmentsExperience(long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, boolean active, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_SEGMENTS_ENTRIES");
        return this.segmentsExperienceLocalService.addSegmentsExperience(segmentsEntryId, classNameId, classPK, nameMap, active, serviceContext);
    }

    public SegmentsExperience deleteSegmentsExperience(long segmentsExperienceId) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceId);
        _segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "DELETE");
        return this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperienceId);
    }

    public SegmentsExperience getSegmentsExperience(long segmentsExperienceId) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceId);
        _segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "VIEW");
        return segmentsExperience;
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK, boolean active) {
        return this.segmentsExperiencePersistence.filterFindByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK, boolean active, int start, int end, OrderByComparator<SegmentsExperience> orderByComparator) {
        return this.segmentsExperiencePersistence.filterFindByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active, start, end, orderByComparator);
    }

    public int getSegmentsExperiencesCount(long groupId, long classNameId, long classPK, boolean active) {
        return this.segmentsExperiencePersistence.filterCountByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active);
    }

    public SegmentsExperience updateSegmentsExperience(long segmentsExperienceId, long segmentsEntryId, Map<Locale, String> nameMap, boolean active) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceId);
        _segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "UPDATE");
        return this.segmentsExperienceLocalService.updateSegmentsExperience(segmentsExperienceId, segmentsEntryId, nameMap, active);
    }

    public void updateSegmentsExperiencePriority(long segmentsExperienceId, int newPriority) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        _segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "UPDATE");
        SegmentsExperience swapSegmentsExperience = this.segmentsExperiencePersistence.fetchByG_C_C_P(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), newPriority);
        if (swapSegmentsExperience != null) {
            _segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)swapSegmentsExperience, "UPDATE");
        }
        this.segmentsExperienceLocalService.updateSegmentsExperiencePriority(segmentsExperienceId, newPriority);
    }

    private long _getPublishedLayoutClassPK(long classPK) {
        Layout layout = this.layoutLocalService.fetchLayout(classPK);
        if (layout != null && layout.getClassNameId() == this.classNameLocalService.getClassNameId(Layout.class) && layout.getClassPK() != 0L) {
            return layout.getClassPK();
        }
        return classPK;
    }
}

