/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.segments.exception.SegmentsExperiencePriorityException;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.base.SegmentsExperienceLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SegmentsExperienceLocalServiceImpl
extends SegmentsExperienceLocalServiceBaseImpl {
    public SegmentsExperience addSegmentsExperience(long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.addSegmentsExperience(segmentsEntryId, classNameId, classPK, nameMap, this.getSegmentsExperiencesCount(serviceContext.getScopeGroupId(), classNameId, classPK), active, serviceContext);
    }

    public SegmentsExperience addSegmentsExperience(long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, int priority, boolean active, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        long publishedClassPK = this._getPublishedLayoutClassPK(classPK);
        this._validate(groupId, classNameId, publishedClassPK, priority);
        long segmentsExperienceId = this.counterLocalService.increment();
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.create(segmentsExperienceId);
        segmentsExperience.setUuid(serviceContext.getUuid());
        segmentsExperience.setGroupId(groupId);
        segmentsExperience.setCompanyId(user.getCompanyId());
        segmentsExperience.setUserId(user.getUserId());
        segmentsExperience.setUserName(user.getFullName());
        segmentsExperience.setCreateDate(serviceContext.getCreateDate(new Date()));
        segmentsExperience.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsExperience.setSegmentsEntryId(segmentsEntryId);
        segmentsExperience.setClassNameId(classNameId);
        segmentsExperience.setClassPK(publishedClassPK);
        segmentsExperience.setNameMap(nameMap);
        segmentsExperience.setPriority(priority);
        segmentsExperience.setActive(active);
        this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
        this.resourceLocalService.addModelResources((AuditedModel)segmentsExperience, serviceContext);
        return segmentsExperience;
    }

    public void deleteSegmentsEntrySegmentsExperiences(long segmentsEntryId) throws PortalException {
        List segmentsExperiences = this.segmentsExperiencePersistence.findBySegmentsEntryId(segmentsEntryId);
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperience.getSegmentsExperienceId());
        }
    }

    @Override
    public SegmentsExperience deleteSegmentsExperience(long segmentsExperienceId) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        return this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperience);
    }

    @Override
    @SystemEvent(type=1)
    public SegmentsExperience deleteSegmentsExperience(SegmentsExperience segmentsExperience) throws PortalException {
        this.segmentsExperiencePersistence.remove((BaseModel)segmentsExperience);
        ArrayList segmentsExperiences = new ArrayList(this.segmentsExperiencePersistence.findByG_C_C_GtP(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), segmentsExperience.getPriority()));
        Collections.reverse(segmentsExperiences);
        for (SegmentsExperience curSegmentsExperience : segmentsExperiences) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                curSegmentsExperience.setPriority(curSegmentsExperience.getPriority() - 1);
                this.segmentsExperienceLocalService.updateSegmentsExperience(curSegmentsExperience);
                return null;
            });
        }
        this.resourceLocalService.deleteResource((AuditedModel)segmentsExperience, 4);
        return segmentsExperience;
    }

    public void deleteSegmentsExperiences(long groupId, long classNameId, long classPK) throws PortalException {
        List segmentsExperiences = this.segmentsExperiencePersistence.findByG_C_C(groupId, classNameId, this._getPublishedLayoutClassPK(classPK));
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperience.getSegmentsExperienceId());
        }
    }

    @Override
    public SegmentsExperience fetchSegmentsExperience(long segmentsExperienceId) {
        return this.segmentsExperiencePersistence.fetchByPrimaryKey(segmentsExperienceId);
    }

    @Override
    public SegmentsExperience getSegmentsExperience(long segmentsExperienceId) throws PortalException {
        return this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK, boolean active) throws PortalException {
        return this.segmentsExperiencePersistence.findByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK, boolean active, int start, int end, OrderByComparator<SegmentsExperience> orderByComparator) {
        return this.segmentsExperiencePersistence.findByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active, start, end, orderByComparator);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long[] segmentsEntryIds, long classNameId, long classPK, boolean active, int start, int end, OrderByComparator<SegmentsExperience> orderByComparator) {
        return this.segmentsExperiencePersistence.findByG_S_C_C_A(groupId, segmentsEntryIds, classNameId, this._getPublishedLayoutClassPK(classPK), active, start, end, orderByComparator);
    }

    public int getSegmentsExperiencesCount(long groupId, long classNameId, long classPK) {
        return this.segmentsExperiencePersistence.countByG_C_C(groupId, classNameId, this._getPublishedLayoutClassPK(classPK));
    }

    public int getSegmentsExperiencesCount(long groupId, long classNameId, long classPK, boolean active) {
        return this.segmentsExperiencePersistence.countByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active);
    }

    public SegmentsExperience updateSegmentsExperience(long segmentsExperienceId, long segmentsEntryId, Map<Locale, String> nameMap, boolean active) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        segmentsExperience.setSegmentsEntryId(segmentsEntryId);
        segmentsExperience.setNameMap(nameMap);
        segmentsExperience.setActive(active);
        return (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
    }

    public SegmentsExperience updateSegmentsExperiencePriority(long segmentsExperienceId, int newPriority) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        int count = this.segmentsExperiencePersistence.countByG_C_C(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK());
        if (newPriority < 0 || newPriority >= count) {
            return segmentsExperience;
        }
        SegmentsExperience swapSegmentsExperience = this.segmentsExperiencePersistence.fetchByG_C_C_P(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), newPriority);
        if (swapSegmentsExperience == null) {
            segmentsExperience.setPriority(newPriority);
            return (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
        }
        int originalPriority = segmentsExperience.getPriority();
        segmentsExperience.setPriority(-2);
        this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
        swapSegmentsExperience.setPriority(-3);
        this.segmentsExperiencePersistence.update((BaseModel)swapSegmentsExperience);
        TransactionCommitCallbackUtil.registerCallback(() -> {
            segmentsExperience.setPriority(newPriority);
            this.segmentsExperienceLocalService.updateSegmentsExperience(segmentsExperience);
            swapSegmentsExperience.setPriority(originalPriority);
            this.segmentsExperienceLocalService.updateSegmentsExperience(swapSegmentsExperience);
            return null;
        });
        return segmentsExperience;
    }

    private long _getPublishedLayoutClassPK(long classPK) {
        Layout layout = this.layoutLocalService.fetchLayout(classPK);
        if (layout != null && layout.getClassNameId() == this.classNameLocalService.getClassNameId(Layout.class) && layout.getClassPK() != 0L) {
            return layout.getClassPK();
        }
        return classPK;
    }

    private void _validate(long groupId, long classNameId, long classPK, int priority) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.fetchByG_C_C_P(groupId, classNameId, classPK, priority);
        if (segmentsExperience != null) {
            throw new SegmentsExperiencePriorityException("A segments experience with the priority " + priority + " already exists");
        }
    }
}

