/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.service.base.SegmentsEntryServiceBaseImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SegmentsEntryServiceImpl
extends SegmentsEntryServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(SegmentsEntryServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.segments");
    private static volatile ModelResourcePermission<SegmentsEntry> _segmentsEntryResourcePermission = ModelResourcePermissionFactory.getInstance(SegmentsEntryServiceImpl.class, (String)"_segmentsEntryResourcePermission", SegmentsEntry.class);

    public SegmentsEntry addSegmentsEntry(String segmentsEntryKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String criteria, String source, String type, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_SEGMENTS_ENTRIES");
        return this.segmentsEntryLocalService.addSegmentsEntry(segmentsEntryKey, nameMap, descriptionMap, active, criteria, source, type, serviceContext);
    }

    public SegmentsEntry deleteSegmentsEntry(long segmentsEntryId) throws PortalException {
        _segmentsEntryResourcePermission.check(this.getPermissionChecker(), segmentsEntryId, "DELETE");
        return this.segmentsEntryLocalService.deleteSegmentsEntry(segmentsEntryId);
    }

    public List<SegmentsEntry> getSegmentsEntries(long groupId, boolean includeAncestorSegmentsEntries) {
        if (!includeAncestorSegmentsEntries) {
            return this.segmentsEntryPersistence.filterFindByGroupId(groupId);
        }
        return this.segmentsEntryPersistence.filterFindByGroupId(ArrayUtil.append((long[])PortalUtil.getAncestorSiteGroupIds((long)groupId), (long)groupId));
    }

    public List<SegmentsEntry> getSegmentsEntries(long groupId, boolean includeAncestorSegmentsEntries, int start, int end, OrderByComparator<SegmentsEntry> orderByComparator) {
        if (!includeAncestorSegmentsEntries) {
            return this.segmentsEntryPersistence.filterFindByGroupId(groupId, start, end, orderByComparator);
        }
        return this.segmentsEntryPersistence.filterFindByGroupId(ArrayUtil.append((long[])PortalUtil.getAncestorSiteGroupIds((long)groupId), (long)groupId), start, end, orderByComparator);
    }

    public int getSegmentsEntriesCount(long groupId, boolean includeAncestorSegmentsEntries) {
        if (!includeAncestorSegmentsEntries) {
            return this.segmentsEntryPersistence.filterCountByGroupId(groupId);
        }
        return this.segmentsEntryPersistence.filterCountByGroupId(ArrayUtil.append((long[])PortalUtil.getAncestorSiteGroupIds((long)groupId), (long)groupId));
    }

    public SegmentsEntry getSegmentsEntry(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryLocalService.getSegmentsEntry(segmentsEntryId);
        _segmentsEntryResourcePermission.check(this.getPermissionChecker(), segmentsEntryId, "VIEW");
        return segmentsEntry;
    }

    public BaseModelSearchResult<SegmentsEntry> searchSegmentsEntries(long companyId, long groupId, String keywords, boolean includeAncestorSegmentsEntries, int start, int end, Sort sort) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "VIEW");
        return this.segmentsEntryLocalService.searchSegmentsEntries(companyId, groupId, keywords, includeAncestorSegmentsEntries, start, end, sort);
    }

    public SegmentsEntry updateSegmentsEntry(long segmentsEntryId, String segmentsEntryKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String criteria, ServiceContext serviceContext) throws PortalException {
        _segmentsEntryResourcePermission.check(this.getPermissionChecker(), segmentsEntryId, "UPDATE");
        return this.segmentsEntryLocalService.updateSegmentsEntry(segmentsEntryId, segmentsEntryKey, nameMap, descriptionMap, active, criteria, serviceContext);
    }
}

