/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.exception.RequiredSegmentsEntryException;
import com.liferay.segments.exception.SegmentsEntryKeyException;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.service.base.SegmentsEntryLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SegmentsEntryLocalServiceImpl
extends SegmentsEntryLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public SegmentsEntry addSegmentsEntry(String segmentsEntryKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String criteria, String source, String type, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        segmentsEntryKey = Validator.isNull((String)segmentsEntryKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)segmentsEntryKey.trim());
        this.validate(0L, groupId, segmentsEntryKey);
        long segmentsEntryId = this.counterLocalService.increment();
        SegmentsEntry segmentsEntry = this.segmentsEntryPersistence.create(segmentsEntryId);
        segmentsEntry.setUuid(serviceContext.getUuid());
        segmentsEntry.setGroupId(groupId);
        segmentsEntry.setCompanyId(user.getCompanyId());
        segmentsEntry.setUserId(user.getUserId());
        segmentsEntry.setUserName(user.getFullName());
        segmentsEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        segmentsEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsEntry.setSegmentsEntryKey(segmentsEntryKey);
        segmentsEntry.setNameMap(nameMap);
        segmentsEntry.setDescriptionMap(descriptionMap);
        segmentsEntry.setActive(active);
        segmentsEntry.setCriteria(criteria);
        if (Validator.isNull((String)source)) {
            segmentsEntry.setSource("DEFAULT");
        } else {
            segmentsEntry.setSource(source);
        }
        segmentsEntry.setType(type);
        this.segmentsEntryPersistence.update((BaseModel)segmentsEntry);
        this.resourceLocalService.addModelResources((AuditedModel)segmentsEntry, serviceContext);
        return segmentsEntry;
    }

    public void deleteSegmentsEntries(long groupId) throws PortalException {
        List segmentsEntries = this.segmentsEntryPersistence.findByGroupId(groupId);
        for (SegmentsEntry segmentsEntry : segmentsEntries) {
            this.segmentsEntryLocalService.deleteSegmentsEntry(segmentsEntry.getSegmentsEntryId());
        }
    }

    public void deleteSegmentsEntries(String source) throws PortalException {
        List segmentsEntries = this.segmentsEntryPersistence.findBySource(source);
        for (SegmentsEntry segmentsEntry : segmentsEntries) {
            this.segmentsEntryLocalService.deleteSegmentsEntry(segmentsEntry);
        }
    }

    @Override
    public SegmentsEntry deleteSegmentsEntry(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryPersistence.findByPrimaryKey(segmentsEntryId);
        return this.segmentsEntryLocalService.deleteSegmentsEntry(segmentsEntry);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public SegmentsEntry deleteSegmentsEntry(SegmentsEntry segmentsEntry) throws PortalException {
        if (!GroupThreadLocal.isDeleteInProcess() && this.segmentsExperiencePersistence.countBySegmentsEntryId(segmentsEntry.getSegmentsEntryId()) > 0) {
            throw new RequiredSegmentsEntryException.MustNotDeleteSegmentsEntryReferencedBySegmentsExperiences(segmentsEntry.getSegmentsEntryId());
        }
        this.segmentsEntryPersistence.remove((BaseModel)segmentsEntry);
        this.resourceLocalService.deleteResource((AuditedModel)segmentsEntry, 4);
        this.segmentsExperienceLocalService.deleteSegmentsEntrySegmentsExperiences(segmentsEntry.getSegmentsEntryId());
        this.segmentsEntryRelLocalService.deleteSegmentsEntryRels(segmentsEntry.getSegmentsEntryId());
        return segmentsEntry;
    }

    public SegmentsEntry fetchSegmentsEntry(long groupId, String segmentsEntryKey, boolean includeAncestorSegmentsEntries) {
        SegmentsEntry segmentsEntry = this.segmentsEntryPersistence.fetchByG_S(groupId, segmentsEntryKey);
        if (segmentsEntry != null) {
            return segmentsEntry;
        }
        for (long ancestorSiteGroupId : PortalUtil.getAncestorSiteGroupIds((long)groupId)) {
            segmentsEntry = this.segmentsEntryPersistence.fetchByG_S(ancestorSiteGroupId, segmentsEntryKey);
            if (segmentsEntry == null) continue;
            return segmentsEntry;
        }
        return null;
    }

    public List<SegmentsEntry> getSegmentsEntries(long groupId, boolean includeAncestorSegmentsEntries, int start, int end, OrderByComparator<SegmentsEntry> orderByComparator) {
        if (!includeAncestorSegmentsEntries) {
            return this.segmentsEntryPersistence.findByGroupId(groupId, start, end, orderByComparator);
        }
        return this.segmentsEntryPersistence.findByGroupId(ArrayUtil.append((long[])PortalUtil.getAncestorSiteGroupIds((long)groupId), (long)groupId), start, end, orderByComparator);
    }

    public List<SegmentsEntry> getSegmentsEntries(long groupId, boolean active, String type, int start, int end, OrderByComparator<SegmentsEntry> orderByComparator) {
        return this.segmentsEntryPersistence.findByG_A_T(ArrayUtil.append((long[])PortalUtil.getAncestorSiteGroupIds((long)groupId), (long)groupId), active, type, start, end, orderByComparator);
    }

    public List<SegmentsEntry> getSegmentsEntriesBySource(String source, int start, int end, OrderByComparator<SegmentsEntry> orderByComparator) {
        return this.segmentsEntryPersistence.findBySource(source, start, end, orderByComparator);
    }

    public int getSegmentsEntriesCount(long groupId, boolean includeAncestorSegmentsEntries) {
        if (!includeAncestorSegmentsEntries) {
            return this.segmentsEntryPersistence.countByGroupId(groupId);
        }
        return this.segmentsEntryPersistence.countByGroupId(ArrayUtil.append((long[])PortalUtil.getAncestorSiteGroupIds((long)groupId), (long)groupId));
    }

    public BaseModelSearchResult<SegmentsEntry> searchSegmentsEntries(long companyId, long groupId, String keywords, boolean includeAncestorSegmentsEntries, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, keywords, includeAncestorSegmentsEntries, start, end, sort);
        return this.segmentsEntryLocalService.searchSegmentsEntries(searchContext);
    }

    public BaseModelSearchResult<SegmentsEntry> searchSegmentsEntries(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(SegmentsEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<SegmentsEntry> segmentsEntries = this.getSegmentsEntries(hits);
            if (segmentsEntries == null) continue;
            return new BaseModelSearchResult(segmentsEntries, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Indexable(type=IndexableType.REINDEX)
    public SegmentsEntry updateSegmentsEntry(long segmentsEntryId, String segmentsEntryKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String criteria, ServiceContext serviceContext) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryPersistence.findByPrimaryKey(segmentsEntryId);
        segmentsEntryKey = FriendlyURLNormalizerUtil.normalize((String)segmentsEntryKey);
        this.validate(segmentsEntryId, segmentsEntry.getGroupId(), segmentsEntryKey);
        segmentsEntry.setSegmentsEntryKey(segmentsEntryKey);
        segmentsEntry.setNameMap(nameMap);
        segmentsEntry.setDescriptionMap(descriptionMap);
        segmentsEntry.setActive(active);
        segmentsEntry.setCriteria(criteria);
        return (SegmentsEntry)this.segmentsEntryPersistence.update((BaseModel)segmentsEntry);
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, String keywords, boolean includeAncestorSegmentsEntries, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", keywords);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("keywords", keywords);
        attributes.put("params", params);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        long[] groupIds = new long[]{groupId};
        if (includeAncestorSegmentsEntries) {
            groupIds = ArrayUtil.append((long[][])new long[][]{groupIds, PortalUtil.getAncestorSiteGroupIds((long)groupId)});
        }
        searchContext.setGroupIds(groupIds);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    protected List<SegmentsEntry> getSegmentsEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<SegmentsEntry> segmentsEntries = new ArrayList<SegmentsEntry>(documents.size());
        for (Document document : documents) {
            long segmentsEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            SegmentsEntry segmentsEntry = this.fetchSegmentsEntry(segmentsEntryId);
            if (segmentsEntry == null) {
                segmentsEntries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(SegmentsEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (segmentsEntries == null) continue;
            segmentsEntries.add(segmentsEntry);
        }
        return segmentsEntries;
    }

    protected void validate(long segmentsEntryId, long groupId, String segmentsEntryKey) throws PortalException {
        SegmentsEntry segmentsEntry = this.fetchSegmentsEntry(groupId, segmentsEntryKey, true);
        if (segmentsEntry != null && segmentsEntry.getSegmentsEntryId() != segmentsEntryId) {
            throw new SegmentsEntryKeyException();
        }
    }
}

