/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.segments.model.SegmentsEntry;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.segments.model.SegmentsEntry"}, service={ModelDocumentContributor.class})
public class SegmentsEntryModelDocumentContributor
implements ModelDocumentContributor<SegmentsEntry> {
    @Reference
    private Portal _portal;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;

    public void contribute(Document document, SegmentsEntry segmentsEntry) {
        document.addKeyword("active", segmentsEntry.isActive());
        document.addLocalizedKeyword("description", segmentsEntry.getDescriptionMap(), true);
        document.addDate("modified", segmentsEntry.getModifiedDate());
        Locale siteDefaultLocale = this._getSiteDefaultLocale(segmentsEntry.getGroupId());
        this._searchLocalizationHelper.addLocalizedField(document, "name", siteDefaultLocale, segmentsEntry.getNameMap());
        document.addLocalizedKeyword("localized_name", LocalizationUtil.populateLocalizationMap((Map)segmentsEntry.getNameMap(), (String)segmentsEntry.getDefaultLanguageId(), (long)segmentsEntry.getGroupId()), true, true);
    }

    private Locale _getSiteDefaultLocale(long groupId) {
        try {
            return this._portal.getSiteDefaultLocale(groupId);
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }
}

