/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.retriever;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchResultPermissionFilter;
import com.liferay.portal.kernel.search.SearchResultPermissionFilterFactory;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.segments.odata.retriever.ODataRetriever;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.User"}, service={ODataRetriever.class})
public class UserODataRetriever
implements ODataRetriever<User> {
    private static final Log _log = LogFactoryUtil.getLog(UserODataRetriever.class);
    private volatile EntityModel _entityModel;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    private FilterParser _filterParser;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private SearchResultPermissionFilterFactory _searchResultPermissionFilterFactory;
    @Reference
    private UserLocalService _userLocalService;

    public List<User> getResults(long companyId, String filterString, Locale locale, int start, int end) throws PortalException {
        try {
            Hits hits = null;
            SearchContext searchContext1 = this._createSearchContext(companyId, start, end);
            Query query = this._getQuery(filterString, locale, searchContext1);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker != null) {
                if (searchContext1.getUserId() == 0L) {
                    searchContext1.setUserId(permissionChecker.getUserId());
                }
                SearchResultPermissionFilter searchResultPermissionFilter = this._searchResultPermissionFilterFactory.create(searchContext2 -> IndexSearcherHelperUtil.search((SearchContext)searchContext2, (Query)query), permissionChecker);
                hits = searchResultPermissionFilter.search(searchContext1);
            } else {
                hits = IndexSearcherHelperUtil.search((SearchContext)searchContext1, (Query)query);
            }
            return this._getUsers(hits);
        }
        catch (Exception e) {
            throw new PortalException("Unable to retrieve users with filter " + filterString, (Throwable)e);
        }
    }

    public int getResultsCount(long companyId, String filterString, Locale locale) throws PortalException {
        try {
            SearchContext searchContext1 = this._createSearchContext(companyId, 0, 0);
            Query query = this._getQuery(filterString, locale, searchContext1);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker != null) {
                if (searchContext1.getUserId() == 0L) {
                    searchContext1.setUserId(permissionChecker.getUserId());
                }
                SearchResultPermissionFilter searchResultPermissionFilter = this._searchResultPermissionFilterFactory.create(searchContext2 -> IndexSearcherHelperUtil.search((SearchContext)searchContext2, (Query)query), permissionChecker);
                Hits hits = searchResultPermissionFilter.search(searchContext1);
                return hits.getLength();
            }
            return (int)IndexSearcherHelperUtil.searchCount((SearchContext)searchContext1, (Query)query);
        }
        catch (Exception e) {
            throw new PortalException("Unable to retrieve users count with filter " + filterString, (Throwable)e);
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=User)", unbind="unbindFilterParser")
    public void setFilterParser(FilterParser filterParser) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding " + filterParser));
        }
        this._filterParser = filterParser;
    }

    public void unbindFilterParser(FilterParser filterParser) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unbinding " + filterParser));
        }
        this._filterParser = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=User)", unbind="unbindEntityModel")
    protected void setEntityModel(EntityModel entityModel) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding " + entityModel));
        }
        this._entityModel = entityModel;
    }

    protected void unbindEntityModel(EntityModel entityModel) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unbinding " + entityModel));
        }
        this._entityModel = null;
    }

    private SearchContext _createSearchContext(long companyId, int start, int end) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private Query _getQuery(String filterString, Locale locale, SearchContext searchContext) throws Exception {
        Indexer indexer = this._indexerRegistry.getIndexer(User.class);
        BooleanQuery booleanQuery = indexer.getFullQuery(searchContext);
        Filter searchFilter = this._getSearchFilter(new com.liferay.portal.odata.filter.Filter(this._filterParser.parse(filterString)), locale);
        if (searchFilter != null) {
            BooleanFilter preBooleanFilter = booleanQuery.getPreBooleanFilter();
            preBooleanFilter.add(searchFilter, BooleanClauseOccur.MUST);
        }
        return booleanQuery;
    }

    private Filter _getSearchFilter(com.liferay.portal.odata.filter.Filter filter, Locale locale) {
        if (filter == null || filter == com.liferay.portal.odata.filter.Filter.emptyFilter()) {
            return null;
        }
        try {
            return (Filter)this._expressionConvert.convert(filter.getExpression(), locale, this._entityModel);
        }
        catch (Exception e) {
            throw new InvalidFilterException("Invalid filter: " + e.getMessage(), (Throwable)e);
        }
    }

    private User _getUser(Document document) throws PortalException {
        long userId = GetterUtil.getLong((String)document.get("userId"));
        return this._userLocalService.getUser(userId);
    }

    private List<User> _getUsers(Hits hits) throws PortalException {
        Document[] documents = hits.getDocs();
        ArrayList<User> users = new ArrayList<User>(documents.length);
        for (Document document : documents) {
            users.add(this._getUser(document));
        }
        return users;
    }
}

