/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.retriever;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchResultPermissionFilter;
import com.liferay.portal.kernel.search.SearchResultPermissionFilterFactory;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.segments.odata.retriever.ODataRetriever;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.Organization"}, service={ODataRetriever.class})
public class OrganizationODataRetriever
implements ODataRetriever<Organization> {
    @Reference(target="(entity.model.name=Organization)")
    private EntityModel _entityModel;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference(target="(entity.model.name=Organization)")
    private FilterParser _filterParser;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private SearchResultPermissionFilterFactory _searchResultPermissionFilterFactory;

    public List<Organization> getResults(long companyId, String filterString, Locale locale, int start, int end) throws PortalException {
        try {
            Hits hits = null;
            SearchContext searchContext1 = this._createSearchContext(companyId, start, end);
            Query query = this._getQuery(filterString, locale, searchContext1);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker != null) {
                if (searchContext1.getUserId() == 0L) {
                    searchContext1.setUserId(permissionChecker.getUserId());
                }
                SearchResultPermissionFilter searchResultPermissionFilter = this._searchResultPermissionFilterFactory.create(searchContext2 -> IndexSearcherHelperUtil.search((SearchContext)searchContext2, (Query)query), permissionChecker);
                hits = searchResultPermissionFilter.search(searchContext1);
            } else {
                hits = IndexSearcherHelperUtil.search((SearchContext)searchContext1, (Query)query);
            }
            return this._getOrganizations(hits);
        }
        catch (Exception e) {
            throw new PortalException("Unable to retrieve organizations with filter " + filterString, (Throwable)e);
        }
    }

    public int getResultsCount(long companyId, String filterString, Locale locale) throws PortalException {
        try {
            SearchContext searchContext1 = this._createSearchContext(companyId, 0, 0);
            Query query = this._getQuery(filterString, locale, searchContext1);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker != null) {
                if (searchContext1.getUserId() == 0L) {
                    searchContext1.setUserId(permissionChecker.getUserId());
                }
                SearchResultPermissionFilter searchResultPermissionFilter = this._searchResultPermissionFilterFactory.create(searchContext2 -> IndexSearcherHelperUtil.search((SearchContext)searchContext2, (Query)query), permissionChecker);
                Hits hits = searchResultPermissionFilter.search(searchContext1);
                return hits.getLength();
            }
            return (int)IndexSearcherHelperUtil.searchCount((SearchContext)searchContext1, (Query)query);
        }
        catch (Exception e) {
            throw new PortalException("Unable to retrieve organizations count with filter " + filterString, (Throwable)e);
        }
    }

    private SearchContext _createSearchContext(long companyId, int start, int end) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private Organization _getOrganization(Document document) throws PortalException {
        long organizationId = GetterUtil.getLong((String)document.get("organizationId"));
        return this._organizationLocalService.getOrganization(organizationId);
    }

    private List<Organization> _getOrganizations(Hits hits) throws PortalException {
        Document[] documents = hits.getDocs();
        ArrayList<Organization> organizations = new ArrayList<Organization>(documents.length);
        for (Document document : documents) {
            organizations.add(this._getOrganization(document));
        }
        return organizations;
    }

    private Query _getQuery(String filterString, Locale locale, SearchContext searchContext) throws Exception {
        Indexer indexer = this._indexerRegistry.getIndexer(Organization.class);
        BooleanQuery booleanQuery = indexer.getFullQuery(searchContext);
        Filter searchFilter = this._getSearchFilter(new com.liferay.portal.odata.filter.Filter(this._filterParser.parse(filterString)), locale);
        if (searchFilter != null) {
            BooleanFilter preBooleanFilter = booleanQuery.getPreBooleanFilter();
            preBooleanFilter.add(searchFilter, BooleanClauseOccur.MUST);
        }
        return booleanQuery;
    }

    private Filter _getSearchFilter(com.liferay.portal.odata.filter.Filter filter, Locale locale) {
        if (filter == null || filter == com.liferay.portal.odata.filter.Filter.emptyFilter()) {
            return null;
        }
        try {
            return (Filter)this._expressionConvert.convert(filter.getExpression(), locale, this._entityModel);
        }
        catch (Exception e) {
            throw new InvalidFilterException("Invalid filter: " + e.getMessage(), (Throwable)e);
        }
    }
}

