/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.filter.expression;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.ComplexPropertyExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MemberExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.PrimitivePropertyExpression;
import com.liferay.portal.odata.filter.expression.PropertyExpression;
import com.liferay.portal.odata.filter.expression.UnaryExpression;
import com.liferay.segments.field.customizer.SegmentsFieldCustomizer;
import com.liferay.segments.field.customizer.SegmentsFieldCustomizerRegistry;
import com.liferay.segments.internal.odata.entity.EntityModelFieldMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ImportExpressionVisitorImpl
implements ExpressionVisitor<Object> {
    private final Map<String, EntityField> _customFieldEntityFields;
    private final EntityModel _entityModel;
    private final EntityModelFieldMapper _entityModelFieldMapper;
    private final StringBuilder _filterStringSB;
    private final PortletDataContext _portletDataContext;
    private final SegmentsFieldCustomizerRegistry _segmentsFieldCustomizerRegistry;

    public ImportExpressionVisitorImpl(PortletDataContext portletDataContext, EntityModel entityModel, EntityModelFieldMapper entityModelFieldMapper, String filterString, SegmentsFieldCustomizerRegistry segmentsFieldCustomizerRegistry) {
        this._portletDataContext = portletDataContext;
        this._entityModel = entityModel;
        this._entityModelFieldMapper = entityModelFieldMapper;
        this._segmentsFieldCustomizerRegistry = segmentsFieldCustomizerRegistry;
        this._customFieldEntityFields = entityModelFieldMapper.getCustomFieldEntityFields(entityModel);
        this._filterStringSB = new StringBuilder(filterString);
    }

    public String visitBinaryExpressionOperation(BinaryExpression.Operation operation, Object left, Object right) {
        if (!Objects.equals(BinaryExpression.Operation.EQ, operation)) {
            return this._filterStringSB.toString();
        }
        EntityField entityField = (EntityField)left;
        if (Objects.equals(EntityField.Type.ID, entityField.getType())) {
            this._importEntityFieldIDReferences(entityField, right);
        } else if (this._customFieldEntityFields.containsKey(entityField.getName())) {
            this._importEntityFieldCustomFieldReferences(entityField);
        }
        return this._filterStringSB.toString();
    }

    public Object visitComplexPropertyExpression(ComplexPropertyExpression complexPropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        ComplexEntityField complexEntityField = (ComplexEntityField)entityFieldsMap.get(complexPropertyExpression.getName());
        PropertyExpression propertyExpression = complexPropertyExpression.getPropertyExpression();
        Map complexEntityFieldEntityFieldsMap = complexEntityField.getEntityFieldsMap();
        return complexEntityFieldEntityFieldsMap.get(propertyExpression.getName());
    }

    public Object visitLiteralExpression(LiteralExpression literalExpression) {
        return StringUtil.removeChar((String)literalExpression.getText(), (char)'\'');
    }

    public Object visitMemberExpression(MemberExpression memberExpression) throws ExpressionVisitException {
        Expression expression = memberExpression.getExpression();
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitMethodExpression(List<Object> expressions, MethodExpression.Type type) {
        throw new UnsupportedOperationException("Unsupported method visitMethodExpression with method type " + type);
    }

    public Object visitPrimitivePropertyExpression(PrimitivePropertyExpression primitivePropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        return entityFieldsMap.get(primitivePropertyExpression.getName());
    }

    public String visitUnaryExpressionOperation(UnaryExpression.Operation operation, Object operand) {
        return this._filterStringSB.toString();
    }

    private void _importEntityFieldCustomFieldReferences(EntityField entityField) {
        long expandoColumnId = this._entityModelFieldMapper.getExpandoColumnId(entityField.getName());
        Map newPrimaryKeysMap = this._portletDataContext.getNewPrimaryKeysMap(ExpandoColumn.class);
        long newPrimaryKey = MapUtil.getLong((Map)newPrimaryKeysMap, (long)GetterUtil.getLong((Object)expandoColumnId), (long)GetterUtil.getLong((Object)expandoColumnId));
        this._replace(this._filterStringSB, String.valueOf(expandoColumnId), String.valueOf(newPrimaryKey));
    }

    private void _importEntityFieldIDReferences(EntityField entityField, Object value) {
        if (!Objects.equals(EntityField.Type.ID, entityField.getType())) {
            return;
        }
        Optional segmentsFieldCustomizerOptional = this._segmentsFieldCustomizerRegistry.getSegmentFieldCustomizerOptional(this._entityModel.getName(), entityField.getName());
        if (!segmentsFieldCustomizerOptional.isPresent()) {
            return;
        }
        SegmentsFieldCustomizer segmentsFieldCustomizer = (SegmentsFieldCustomizer)segmentsFieldCustomizerOptional.get();
        String className = segmentsFieldCustomizer.getClassName();
        if (className == null) {
            return;
        }
        Map newPrimaryKeysMap = this._portletDataContext.getNewPrimaryKeysMap(className);
        long newPrimaryKey = MapUtil.getLong((Map)newPrimaryKeysMap, (long)GetterUtil.getLong((Object)value), (long)GetterUtil.getLong((Object)value));
        this._replace(this._filterStringSB, (String)value, String.valueOf(newPrimaryKey));
    }

    private void _replace(StringBuilder sb, String oldValue, String newValue) {
        int pos = sb.indexOf(oldValue);
        sb.replace(pos, pos + oldValue.length(), newValue);
    }
}

