/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.filter.expression;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.ComplexPropertyExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MemberExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.PrimitivePropertyExpression;
import com.liferay.portal.odata.filter.expression.PropertyExpression;
import com.liferay.portal.odata.filter.expression.UnaryExpression;
import com.liferay.segments.field.customizer.SegmentsFieldCustomizer;
import com.liferay.segments.field.customizer.SegmentsFieldCustomizerRegistry;
import com.liferay.segments.internal.odata.entity.EntityModelFieldMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExportExpressionVisitorImpl
implements ExpressionVisitor<Object> {
    private final Map<String, EntityField> _customFieldEntityFields;
    private final EntityModel _entityModel;
    private final EntityModelFieldMapper _entityModelFieldMapper;
    private final PortletDataContext _portletDataContext;
    private final SegmentsFieldCustomizerRegistry _segmentsFieldCustomizerRegistry;
    private final StagedModel _stagedModel;

    public ExportExpressionVisitorImpl(PortletDataContext portletDataContext, StagedModel stagedModel, EntityModel entityModel, EntityModelFieldMapper entityModelFieldMapper, SegmentsFieldCustomizerRegistry segmentsFieldCustomizerRegistry) {
        this._portletDataContext = portletDataContext;
        this._stagedModel = stagedModel;
        this._entityModel = entityModel;
        this._entityModelFieldMapper = entityModelFieldMapper;
        this._segmentsFieldCustomizerRegistry = segmentsFieldCustomizerRegistry;
        this._customFieldEntityFields = entityModelFieldMapper.getCustomFieldEntityFields(entityModel);
    }

    public Void visitBinaryExpressionOperation(BinaryExpression.Operation operation, Object left, Object right) {
        if (!Objects.equals(BinaryExpression.Operation.EQ, operation)) {
            return null;
        }
        EntityField entityField = (EntityField)left;
        if (Objects.equals(EntityField.Type.ID, entityField.getType())) {
            this._exportEntityFieldIDReferences(entityField, right);
        } else if (this._customFieldEntityFields.containsKey(entityField.getName())) {
            this._exportEntityFieldCustomFieldReferences(entityField);
        }
        return null;
    }

    public Object visitComplexPropertyExpression(ComplexPropertyExpression complexPropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        ComplexEntityField complexEntityField = (ComplexEntityField)entityFieldsMap.get(complexPropertyExpression.getName());
        PropertyExpression propertyExpression = complexPropertyExpression.getPropertyExpression();
        Map complexEntityFieldEntityFieldsMap = complexEntityField.getEntityFieldsMap();
        return complexEntityFieldEntityFieldsMap.get(propertyExpression.getName());
    }

    public Object visitLiteralExpression(LiteralExpression literalExpression) {
        return StringUtil.removeChar((String)literalExpression.getText(), (char)'\'');
    }

    public Object visitMemberExpression(MemberExpression memberExpression) throws ExpressionVisitException {
        Expression expression = memberExpression.getExpression();
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitMethodExpression(List<Object> expressions, MethodExpression.Type type) {
        throw new UnsupportedOperationException("Unsupported method visitMethodExpression with method type " + type);
    }

    public Object visitPrimitivePropertyExpression(PrimitivePropertyExpression primitivePropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        return entityFieldsMap.get(primitivePropertyExpression.getName());
    }

    public Void visitUnaryExpressionOperation(UnaryExpression.Operation operation, Object operand) {
        return null;
    }

    private void _exportEntityFieldCustomFieldReferences(EntityField entityField) {
        ExpandoColumn expandoColumn = this._entityModelFieldMapper.getExpandoColumn(entityField.getName());
        if (expandoColumn == null) {
            return;
        }
        Element entityElement = this._portletDataContext.getExportDataElement((ClassedModel)this._stagedModel);
        this._portletDataContext.addReferenceElement((ClassedModel)this._stagedModel, entityElement, (ClassedModel)expandoColumn, "dependency", false);
    }

    private void _exportEntityFieldIDReferences(EntityField entityField, Object value) {
        if (!Objects.equals(EntityField.Type.ID, entityField.getType())) {
            return;
        }
        Optional segmentsFieldCustomizerOptional = this._segmentsFieldCustomizerRegistry.getSegmentFieldCustomizerOptional(this._entityModel.getName(), entityField.getName());
        if (!segmentsFieldCustomizerOptional.isPresent()) {
            return;
        }
        SegmentsFieldCustomizer segmentsFieldCustomizer = (SegmentsFieldCustomizer)segmentsFieldCustomizerOptional.get();
        ClassedModel classedModel = segmentsFieldCustomizer.getClassedModel((String)value);
        if (classedModel == null) {
            return;
        }
        Element entityElement = this._portletDataContext.getExportDataElement((ClassedModel)this._stagedModel);
        this._portletDataContext.addReferenceElement((ClassedModel)this._stagedModel, entityElement, classedModel, "dependency", false);
    }
}

