/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.filter.expression;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.CollectionEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.CollectionPropertyExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.LambdaFunctionExpression;
import com.liferay.portal.odata.filter.expression.LambdaVariableExpression;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MemberExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.PrimitivePropertyExpression;
import com.liferay.portal.odata.filter.expression.UnaryExpression;
import com.liferay.segments.context.Context;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ContextExpressionVisitorImpl
implements ExpressionVisitor<Object> {
    private final EntityModel _entityModel;
    private final CollectionEntityField _lambdaCollectionEntityField;

    public ContextExpressionVisitorImpl(EntityModel entityModel) {
        this._entityModel = entityModel;
        this._lambdaCollectionEntityField = null;
    }

    public ContextExpressionVisitorImpl(EntityModel entityModel, CollectionEntityField lambdaCollectionEntityField) {
        this._entityModel = entityModel;
        this._lambdaCollectionEntityField = lambdaCollectionEntityField;
    }

    public Predicate<Context> visitBinaryExpressionOperation(BinaryExpression.Operation operation, Object left, Object right) {
        Optional<Object> predicateOptional = Optional.empty();
        predicateOptional = this._lambdaCollectionEntityField != null ? this._getLambdaPredicateOptional(operation, left, right) : this._getPredicateOptional(operation, left, right);
        return (Predicate)predicateOptional.orElseThrow(() -> new UnsupportedOperationException("Unsupported method visitBinaryExpressionOperation with operation " + operation));
    }

    public Object visitCollectionPropertyExpression(CollectionPropertyExpression collectionPropertyExpression) throws ExpressionVisitException {
        LambdaFunctionExpression lambdaFunctionExpression = collectionPropertyExpression.getLambdaFunctionExpression();
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        CollectionEntityField collectionEntityField = (CollectionEntityField)entityFieldsMap.get(collectionPropertyExpression.getName());
        return lambdaFunctionExpression.accept((ExpressionVisitor)new ContextExpressionVisitorImpl(this._getLambdaEntityModel(lambdaFunctionExpression.getVariableName(), collectionEntityField), collectionEntityField));
    }

    public Object visitLambdaFunctionExpression(LambdaFunctionExpression.Type type, String variable, Expression expression) throws ExpressionVisitException {
        if (type == LambdaFunctionExpression.Type.ANY) {
            return this._any(expression);
        }
        throw new UnsupportedOperationException("Unsupported type visitLambdaFunctionExpression with type " + type);
    }

    public EntityField visitLambdaVariableExpression(LambdaVariableExpression lambdaVariableExpression) throws ExpressionVisitException {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        EntityField entityField = (EntityField)entityFieldsMap.get(lambdaVariableExpression.getVariableName());
        if (entityField == null) {
            throw new ExpressionVisitException("Invoked visitlambdavariableexpression when no entity field is stored for lambda variable name " + lambdaVariableExpression.getVariableName());
        }
        return entityField;
    }

    public Object visitLiteralExpression(LiteralExpression literalExpression) {
        if (Objects.equals(LiteralExpression.Type.BOOLEAN, literalExpression.getType())) {
            return Boolean.valueOf(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.DATE, literalExpression.getType())) {
            return LocalDate.parse(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.DATE_TIME, literalExpression.getType())) {
            return ZonedDateTime.parse(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.DOUBLE, literalExpression.getType())) {
            return Double.valueOf(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.INTEGER, literalExpression.getType())) {
            return Integer.valueOf(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.STRING, literalExpression.getType())) {
            return this._normalizeStringLiteral(literalExpression.getText());
        }
        return literalExpression.getText();
    }

    public Object visitMemberExpression(MemberExpression memberExpression) throws ExpressionVisitException {
        Expression expression = memberExpression.getExpression();
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitMethodExpression(List<Object> expressions, MethodExpression.Type type) {
        if (type == MethodExpression.Type.CONTAINS) {
            if (expressions.size() != 2) {
                throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported method visitMethodExpression with method", "type ", type, " and ", expressions.size(), " parameters"}));
            }
            if (this._lambdaCollectionEntityField != null) {
                return this._getLambdaContainsPredicate((EntityField)expressions.get(0), expressions.get(1));
            }
            return this._getContainsPredicate((EntityField)expressions.get(0), expressions.get(1));
        }
        throw new UnsupportedOperationException("Unsupported method visitMethodExpression with method type " + type);
    }

    public Object visitPrimitivePropertyExpression(PrimitivePropertyExpression primitivePropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        return entityFieldsMap.get(primitivePropertyExpression.getName());
    }

    public Predicate<Context> visitUnaryExpressionOperation(UnaryExpression.Operation operation, Object operand) {
        if (Objects.equals(UnaryExpression.Operation.NOT, operation)) {
            return this._getNotPredicate((Predicate)operand);
        }
        throw new UnsupportedOperationException("Unsupported method visitUnaryExpressionOperation with operation " + operation);
    }

    private Object _any(Expression expression) throws ExpressionVisitException {
        return expression.accept((ExpressionVisitor)this);
    }

    private Predicate<Context> _getANDPredicate(Predicate<Context> leftPredicate, Predicate<Context> rightPredicate) {
        return leftPredicate.and(rightPredicate);
    }

    private Predicate<Context> _getContainsPredicate(EntityField entityField, Object fieldValue) {
        if (Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            return p -> StringUtils.containsIgnoreCase((CharSequence)String.valueOf(p.get(entityField.getName())), (CharSequence)String.valueOf(fieldValue));
        }
        throw new UnsupportedOperationException("Unsupported method _contains with entity field type " + entityField.getType());
    }

    private Predicate<Context> _getEQPredicate(EntityField entityField, Object fieldValue) {
        Predicate<Context> predicate = null;
        predicate = Objects.equals(entityField.getType(), EntityField.Type.STRING) ? p -> fieldValue.equals(this._normalizeStringLiteral(String.valueOf(p.get(entityField.getName())))) : p -> fieldValue.equals(p.get(entityField.getName()));
        return predicate;
    }

    private Predicate<Context> _getGEPredicate(EntityField entityField, Object fieldValue) {
        if (fieldValue instanceof Comparable && (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING))) {
            return p -> ((Comparable)fieldValue).compareTo(p.get(entityField.getName())) <= 0;
        }
        throw new UnsupportedOperationException("Unsupported method _getGEPredicate with entity field type " + entityField.getType());
    }

    private Predicate<Context> _getGTPredicate(EntityField entityField, Object fieldValue) {
        if (fieldValue instanceof Comparable && (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING))) {
            return p -> ((Comparable)fieldValue).compareTo(p.get(entityField.getName())) < 0;
        }
        throw new UnsupportedOperationException("Unsupported method _getGTPredicate with entity field type " + entityField.getType());
    }

    private Predicate<Context> _getLambdaContainsPredicate(EntityField entityField, Object fieldValue) {
        if (Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            return p -> Stream.of((String[])p.get(this._lambdaCollectionEntityField.getName())).anyMatch(c -> StringUtils.containsIgnoreCase((CharSequence)String.valueOf(c), (CharSequence)String.valueOf(fieldValue)));
        }
        throw new UnsupportedOperationException("Unsupported method _lambdaContains with entity field type " + entityField.getType());
    }

    private EntityModel _getLambdaEntityModel(final String variableName, final CollectionEntityField collectionEntityField) {
        return new EntityModel(){

            public Map<String, EntityField> getEntityFieldsMap() {
                return Collections.singletonMap(variableName, collectionEntityField.getEntityField());
            }

            public String getName() {
                return collectionEntityField.getName();
            }
        };
    }

    private Predicate<Context> _getLambdaEQPredicate(EntityField entityField, Object fieldValue) {
        if (Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            return p -> Stream.of((String[])p.get(this._lambdaCollectionEntityField.getName())).anyMatch(c -> fieldValue.equals(this._normalizeStringLiteral(String.valueOf(c))));
        }
        throw new UnsupportedOperationException("Unsupported method _getLambdaEQPredicate with entity field type " + entityField.getType());
    }

    private Optional<Predicate<Context>> _getLambdaPredicateOptional(BinaryExpression.Operation operation, Object left, Object right) {
        if (Objects.equals(BinaryExpression.Operation.EQ, operation)) {
            return Optional.of(this._getLambdaEQPredicate((EntityField)left, right));
        }
        return Optional.empty();
    }

    private Predicate<Context> _getLEPredicate(EntityField entityField, Object fieldValue) {
        if (fieldValue instanceof Comparable && (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING))) {
            return p -> ((Comparable)fieldValue).compareTo(p.get(entityField.getName())) >= 0;
        }
        throw new UnsupportedOperationException("Unsupported method _getLEPredicate with entity field type " + entityField.getType());
    }

    private Predicate<Context> _getLTPredicate(EntityField entityField, Object fieldValue) {
        if (fieldValue instanceof Comparable && (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING))) {
            return p -> ((Comparable)fieldValue).compareTo(p.get(entityField.getName())) > 0;
        }
        throw new UnsupportedOperationException("Unsupported method _getLTPredicate with entity field type " + entityField.getType());
    }

    private Predicate<Context> _getNotPredicate(Predicate<Context> predicate) {
        return predicate.negate();
    }

    private Predicate<Context> _getORPredicate(Predicate<Context> leftPredicate, Predicate<Context> rightPredicate) {
        return leftPredicate.or(rightPredicate);
    }

    private Optional<Predicate<Context>> _getPredicateOptional(BinaryExpression.Operation operation, Object left, Object right) {
        Predicate<Context> predicate = null;
        if (Objects.equals(BinaryExpression.Operation.AND, operation)) {
            predicate = this._getANDPredicate((Predicate)left, (Predicate)right);
        } else if (Objects.equals(BinaryExpression.Operation.EQ, operation)) {
            predicate = this._getEQPredicate((EntityField)left, right);
        } else if (Objects.equals(BinaryExpression.Operation.GE, operation)) {
            predicate = this._getGEPredicate((EntityField)left, right);
        } else if (Objects.equals(BinaryExpression.Operation.GT, operation)) {
            predicate = this._getGTPredicate((EntityField)left, right);
        } else if (Objects.equals(BinaryExpression.Operation.LE, operation)) {
            predicate = this._getLEPredicate((EntityField)left, right);
        } else if (Objects.equals(BinaryExpression.Operation.LT, operation)) {
            predicate = this._getLTPredicate((EntityField)left, right);
        } else if (Objects.equals(BinaryExpression.Operation.OR, operation)) {
            predicate = this._getORPredicate((Predicate)left, (Predicate)right);
        } else {
            return Optional.empty();
        }
        return Optional.of(predicate);
    }

    private Object _normalizeStringLiteral(String literal) {
        literal = StringUtil.toLowerCase((String)literal);
        literal = StringUtil.unquote((String)literal);
        return StringUtil.replace((String)literal, (String)"''", (String)"'");
    }
}

