/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.entity;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.normalizer.Normalizer;
import com.liferay.segments.field.Field;
import com.liferay.segments.field.customizer.SegmentsFieldCustomizer;
import com.liferay.segments.field.customizer.SegmentsFieldCustomizerRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={EntityModelFieldMapper.class})
public class EntityModelFieldMapper {
    private static final Log _log = LogFactoryUtil.getLog(EntityModelFieldMapper.class);
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsFieldCustomizerRegistry _segmentsFieldCustomizerRegistry;

    public Map<String, EntityField> getCustomFieldEntityFields(EntityModel entityModel) {
        Map entityFieldsMap = entityModel.getEntityFieldsMap();
        ComplexEntityField customFieldEntityField = (ComplexEntityField)entityFieldsMap.get("customField");
        if (customFieldEntityField == null) {
            return Collections.emptyMap();
        }
        return customFieldEntityField.getEntityFieldsMap();
    }

    public ExpandoColumn getExpandoColumn(String entityFieldName) {
        long expandoColumnId = this.getExpandoColumnId(entityFieldName);
        try {
            return this._expandoColumnLocalService.getColumn(expandoColumnId);
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to find Expando Column with id " + expandoColumnId), (Throwable)pe);
            return null;
        }
    }

    public String getExpandoColumnEntityFieldName(ExpandoColumn expandoColumn) {
        return StringBundler.concat((Object[])new Object[]{"_", expandoColumn.getColumnId(), "_", Normalizer.normalizeIdentifier((String)expandoColumn.getName())});
    }

    public long getExpandoColumnId(String entityFieldName) {
        String[] split = StringUtil.split((String)entityFieldName, (String)"_");
        if (split.length < 2) {
            return 0L;
        }
        return Long.valueOf(split[1]);
    }

    public List<Field> getFields(EntityModel entityModel, PortletRequest portletRequest) {
        Map entityFieldsMap = entityModel.getEntityFieldsMap();
        ArrayList<Field> fields = new ArrayList<Field>();
        entityFieldsMap.forEach((entityFieldName, entityField) -> fields.addAll(this.getFields(entityModel, (EntityField)entityField, portletRequest)));
        Collections.sort(fields);
        return fields;
    }

    protected List<Field> getFields(EntityModel entityModel, EntityField entityField, PortletRequest portletRequest) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)this._portal.getLocale(portletRequest), this.getClass());
        Optional segmentsFieldCustomizerOptional = this._segmentsFieldCustomizerRegistry.getSegmentFieldCustomizerOptional(entityModel.getName(), entityField.getName());
        if (segmentsFieldCustomizerOptional.isPresent()) {
            SegmentsFieldCustomizer segmentsFieldCustomizer = (SegmentsFieldCustomizer)segmentsFieldCustomizerOptional.get();
            return Collections.singletonList(new Field(entityField.getName(), segmentsFieldCustomizer.getLabel(entityField.getName(), resourceBundle.getLocale()), this.getType(entityField.getType()), segmentsFieldCustomizer.getOptions(resourceBundle.getLocale()), segmentsFieldCustomizer.getSelectEntity(portletRequest)));
        }
        EntityField.Type entityFieldType = entityField.getType();
        if (entityFieldType == EntityField.Type.COMPLEX) {
            Map entityFieldsMap = ((ComplexEntityField)entityField).getEntityFieldsMap();
            return this._getComplexFields(entityField.getName(), entityFieldsMap, resourceBundle);
        }
        if (entityFieldType == EntityField.Type.ID) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Field(entityField.getName(), this._getEntityFieldLabel(entityField, resourceBundle), this.getType(entityFieldType)));
    }

    protected String getType(EntityField.Type entityFieldType) {
        if (entityFieldType == EntityField.Type.BOOLEAN) {
            return "boolean";
        }
        if (entityFieldType == EntityField.Type.COLLECTION) {
            return "collection";
        }
        if (entityFieldType == EntityField.Type.DATE) {
            return "date";
        }
        if (entityFieldType == EntityField.Type.DATE_TIME) {
            return "date-time";
        }
        if (entityFieldType == EntityField.Type.DOUBLE) {
            return "double";
        }
        if (entityFieldType == EntityField.Type.ID) {
            return "id";
        }
        if (entityFieldType == EntityField.Type.INTEGER) {
            return "integer";
        }
        return "string";
    }

    private List<Field> _getComplexFields(String name, Map<String, EntityField> entityFieldsMap, ResourceBundle resourceBundle) {
        if (!name.equals("customField")) {
            return Collections.emptyList();
        }
        ArrayList<Field> complexFields = new ArrayList<Field>();
        entityFieldsMap.forEach((entityFieldName, entityField) -> {
            ExpandoColumn expandoColumn = this.getExpandoColumn((String)entityFieldName);
            if (expandoColumn == null) {
                return;
            }
            String label = expandoColumn.getDisplayName(resourceBundle.getLocale());
            String type = this.getType(entityField.getType());
            complexFields.add(new Field("customField/" + entityFieldName, label, type, this._getExpandoColumnFieldOptions(expandoColumn), null));
        });
        return complexFields;
    }

    private String _getEntityFieldLabel(EntityField entityField, ResourceBundle resourceBundle) {
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)("field." + CamelCaseUtil.fromCamelCase((String)entityField.getName())));
    }

    private List<Field.Option> _getExpandoColumnFieldOptions(ExpandoColumn expandoColumn) {
        ArrayList<Field.Option> fieldOptions;
        block4: {
            block5: {
                block3: {
                    fieldOptions = new ArrayList<Field.Option>();
                    if (expandoColumn.getType() != 6) break block3;
                    for (double value : (double[])expandoColumn.getDefaultValue()) {
                        fieldOptions.add(new Field.Option(String.valueOf(value), String.valueOf(value)));
                    }
                    break block4;
                }
                if (expandoColumn.getType() != 10) break block5;
                for (int value : (int[])expandoColumn.getDefaultValue()) {
                    fieldOptions.add(new Field.Option(String.valueOf(value), String.valueOf(value)));
                }
                break block4;
            }
            if (expandoColumn.getType() != 16) break block4;
            for (String value : (String[])expandoColumn.getDefaultValue()) {
                fieldOptions.add(new Field.Option(value, value));
            }
        }
        return fieldOptions;
    }
}

