/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.messaging;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.PortalPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.internal.asah.client.AsahFaroBackendClient;
import com.liferay.segments.internal.asah.client.AsahFaroBackendClientImpl;
import com.liferay.segments.internal.asah.client.JSONWebServiceClient;
import com.liferay.segments.internal.asah.client.model.Individual;
import com.liferay.segments.internal.asah.client.model.IndividualSegment;
import com.liferay.segments.internal.asah.client.model.Results;
import com.liferay.segments.internal.asah.client.util.OrderByField;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AsahFaroBackendIndividualSegmentsCheckerUtil.class})
public class AsahFaroBackendIndividualSegmentsCheckerUtil {
    private static final int _DELTA = 100;
    private static final Log _log = LogFactoryUtil.getLog(AsahFaroBackendIndividualSegmentsCheckerUtil.class);
    private AsahFaroBackendClient _asahFaroBackendClient;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private JSONWebServiceClient _jsonWebServiceClient;
    @Reference
    private Portal _portal;
    @Reference
    private PortalPreferencesLocalService _portalPreferencesLocalService;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsEntryRelLocalService _segmentsEntryRelLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void checkIndividualSegments() throws PortalException {
        Optional<AsahFaroBackendClient> asahFaroBackendClientOptional = this._createAsahFaroBackendClient();
        if (!asahFaroBackendClientOptional.isPresent()) {
            return;
        }
        this._asahFaroBackendClient = asahFaroBackendClientOptional.get();
        this._checkIndividualSegments();
        this._checkIndividualSegmentsMemberships();
    }

    private void _addSegmentsEntry(final IndividualSegment individualSegment, ServiceContext serviceContext) {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>(){
            {
                this.put(LocaleUtil.getDefault(), individualSegment.getName());
            }
        };
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(serviceContext.getScopeGroupId(), individualSegment.getId(), true);
        try {
            if (segmentsEntry == null) {
                this._segmentsEntryLocalService.addSegmentsEntry(individualSegment.getId(), (Map)nameMap, Collections.emptyMap(), true, null, "ASAH_FARO_BACKEND", User.class.getName(), serviceContext);
                return;
            }
            this._segmentsEntryLocalService.updateSegmentsEntry(segmentsEntry.getSegmentsEntryId(), individualSegment.getId(), (Map)nameMap, null, true, null, serviceContext);
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to process individual segment " + individualSegment.getId()), (Throwable)pe);
        }
    }

    private void _addSegmentsEntryRel(SegmentsEntry segmentsEntry, Individual individual, ServiceContext serviceContext) {
        Optional<Long> userIdOptional = this._getUserIdOptional(individual);
        if (!userIdOptional.isPresent()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to find a user corresponding to individual " + individual.getId()));
            }
            return;
        }
        try {
            long userClassNameId = this._classNameLocalService.getClassNameId(User.class.getName());
            this._segmentsEntryRelLocalService.addSegmentsEntryRel(segmentsEntry.getSegmentsEntryId(), userClassNameId, userIdOptional.get().longValue(), serviceContext);
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to process individual " + individual.getId()), (Throwable)pe);
        }
    }

    private void _checkIndividualSegmentMemberships(SegmentsEntry segmentsEntry) throws PortalException {
        this._segmentsEntryRelLocalService.deleteSegmentsEntryRels(segmentsEntry.getSegmentsEntryId());
        try {
            Results<Individual> individualResults = this._asahFaroBackendClient.getIndividualResults(segmentsEntry.getSegmentsEntryKey(), 1, 100, Collections.singletonList(OrderByField.desc("dateModified")));
            int totalElements = individualResults.getTotal();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(totalElements + " individuals found for individual segment " + segmentsEntry.getSegmentsEntryKey()));
            }
            if (totalElements == 0) {
                return;
            }
            int totalPages = (int)Math.ceil((double)totalElements / 100.0);
            ServiceContext serviceContext = this._getServiceContext();
            int curPage = 1;
            while (true) {
                List<Individual> individuals = individualResults.getItems();
                individuals.forEach(individual -> this._addSegmentsEntryRel(segmentsEntry, (Individual)individual, serviceContext));
                if (++curPage <= totalPages) {
                    individualResults = this._asahFaroBackendClient.getIndividualResults(segmentsEntry.getSegmentsEntryKey(), curPage, 100, Collections.singletonList(OrderByField.desc("dateModified")));
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException re) {
            _log.error((Object)("Unable to retrieve individuals for individual segment " + segmentsEntry.getSegmentsEntryKey()), (Throwable)re);
        }
    }

    private void _checkIndividualSegments() throws PortalException {
        Results<Object> individualSegmentResults = new Results();
        try {
            individualSegmentResults = this._asahFaroBackendClient.getIndividualSegmentResults(1, 100, Collections.singletonList(OrderByField.desc("dateModified")));
        }
        catch (RuntimeException re) {
            _log.error((Object)"Unable to retrieve individual segments", (Throwable)re);
            return;
        }
        int totalElements = individualSegmentResults.getTotal();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(totalElements + " active individual segments found"));
        }
        if (totalElements == 0) {
            return;
        }
        ServiceContext serviceContext = this._getServiceContext();
        List<Object> individualSegments = individualSegmentResults.getItems();
        individualSegments.forEach(individualSegment -> this._addSegmentsEntry((IndividualSegment)individualSegment, serviceContext));
    }

    private void _checkIndividualSegmentsMemberships() throws PortalException {
        List segmentsEntries = this._segmentsEntryLocalService.getSegmentsEntriesBySource("ASAH_FARO_BACKEND", -1, -1, null);
        for (SegmentsEntry segmentsEntry : segmentsEntries) {
            this._checkIndividualSegmentMemberships(segmentsEntry);
        }
    }

    private Optional<AsahFaroBackendClient> _createAsahFaroBackendClient() {
        Company company = this._companyLocalService.fetchCompany(this._portal.getDefaultCompanyId());
        PortletPreferences portletPreferences = this._portalPreferencesLocalService.getPreferences(company.getCompanyId(), 1);
        String asahFaroBackendDataSourceId = GetterUtil.getString((String)portletPreferences.getValue("liferayAnalyticsDataSourceId", null));
        String asahFaroBackendSecuritySignature = GetterUtil.getString((String)portletPreferences.getValue("liferayAnalyticsFaroBackendSecuritySignature", null));
        String asahFaroBackendURL = GetterUtil.getString((String)portletPreferences.getValue("liferayAnalyticsFaroBackendURL", null));
        if (Validator.isNull((String)asahFaroBackendDataSourceId) || Validator.isNull((String)asahFaroBackendSecuritySignature) || Validator.isNull((String)asahFaroBackendURL)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Unable to configure Asah Faro backend client");
            }
            return Optional.empty();
        }
        return Optional.of(new AsahFaroBackendClientImpl(this._jsonWebServiceClient, asahFaroBackendDataSourceId, asahFaroBackendSecuritySignature, asahFaroBackendURL));
    }

    private ServiceContext _getServiceContext() throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        Company company = this._companyLocalService.getCompany(this._portal.getDefaultCompanyId());
        serviceContext.setScopeGroupId(company.getGroupId());
        User user = company.getDefaultUser();
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    private Optional<Long> _getUserIdOptional(Individual individual) {
        Map<String, Set<String>> dataSourceIndividualPKs = individual.getDataSourceIndividualPKs();
        Set<String> individualUuids = dataSourceIndividualPKs.get(this._asahFaroBackendClient.getDataSourceId());
        if (SetUtil.isEmpty(individualUuids)) {
            return Optional.empty();
        }
        Stream stream = individualUuids.stream();
        return stream.map(individualUuid -> this._userLocalService.fetchUserByUuidAndCompanyId(individualUuid, this._portal.getDefaultCompanyId())).filter(Objects::nonNull).findFirst().map(UserModel::getUserId);
    }
}

