/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.exportimport.content.processor;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.CriteriaSerializer;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributorRegistry;
import com.liferay.segments.field.customizer.SegmentsFieldCustomizerRegistry;
import com.liferay.segments.internal.odata.entity.EntityModelFieldMapper;
import com.liferay.segments.internal.odata.filter.expression.ExportExpressionVisitorImpl;
import com.liferay.segments.internal.odata.filter.expression.ImportExpressionVisitorImpl;
import com.liferay.segments.model.SegmentsEntry;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.segments.model.SegmentsEntry"}, service={ExportImportContentProcessor.class, SegmentsEntryExportImportContentProcessor.class})
public class SegmentsEntryExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    @Reference
    private EntityModelFieldMapper _entityModelFieldMapper;
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private SegmentsCriteriaContributorRegistry _segmentsCriteriaContributorRegistry;
    @Reference
    private SegmentsFieldCustomizerRegistry _segmentsFieldCustomizerRegistry;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        Criteria criteria = CriteriaSerializer.deserialize((String)content);
        return this._replaceExportCriteriaReferences(portletDataContext, stagedModel, criteria);
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        Criteria criteria = CriteriaSerializer.deserialize((String)content);
        return this._replaceImportSegmentsEntryReferences(portletDataContext, stagedModel, criteria);
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
    }

    private String _replaceExportCriteriaReferences(PortletDataContext portletDataContext, StagedModel stagedModel, Criteria criteria) throws Exception {
        SegmentsEntry segmentsEntry = (SegmentsEntry)stagedModel;
        List segmentsCriteriaContributors = this._segmentsCriteriaContributorRegistry.getSegmentsCriteriaContributors(segmentsEntry.getType(), Criteria.Type.MODEL);
        for (SegmentsCriteriaContributor segmentsCriteriaContributor : segmentsCriteriaContributors) {
            Criteria.Criterion criterion = segmentsCriteriaContributor.getCriterion(criteria);
            if (criterion == null) continue;
            FilterParser filterParser = this._filterParserProvider.provide(segmentsCriteriaContributor.getEntityModel());
            Filter filter = new Filter(filterParser.parse(criterion.getFilterString()));
            Expression expression = filter.getExpression();
            expression.accept((ExpressionVisitor)new ExportExpressionVisitorImpl(portletDataContext, stagedModel, segmentsCriteriaContributor.getEntityModel(), this._entityModelFieldMapper, this._segmentsFieldCustomizerRegistry));
        }
        return CriteriaSerializer.serialize((Criteria)criteria);
    }

    private String _replaceImportSegmentsEntryReferences(PortletDataContext portletDataContext, StagedModel stagedModel, Criteria criteria) throws Exception {
        SegmentsEntry segmentsEntry = (SegmentsEntry)stagedModel;
        List segmentsCriteriaContributors = this._segmentsCriteriaContributorRegistry.getSegmentsCriteriaContributors(segmentsEntry.getType(), Criteria.Type.MODEL);
        Criteria importCriteria = new Criteria();
        for (SegmentsCriteriaContributor segmentsCriteriaContributor : segmentsCriteriaContributors) {
            Criteria.Criterion criterion = segmentsCriteriaContributor.getCriterion(criteria);
            if (criterion == null) continue;
            FilterParser filterParser = this._filterParserProvider.provide(segmentsCriteriaContributor.getEntityModel());
            Filter filter = new Filter(filterParser.parse(criterion.getFilterString()));
            Expression expression = filter.getExpression();
            String filterString = (String)expression.accept((ExpressionVisitor)new ImportExpressionVisitorImpl(portletDataContext, segmentsCriteriaContributor.getEntityModel(), this._entityModelFieldMapper, criterion.getFilterString(), this._segmentsFieldCustomizerRegistry));
            segmentsCriteriaContributor.contribute(importCriteria, filterString, Criteria.Conjunction.parse((String)criterion.getConjunction()));
        }
        return CriteriaSerializer.serialize((Criteria)importCriteria);
    }
}

