/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.events;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.internal.configuration.SegmentsServiceConfiguration;
import com.liferay.segments.internal.context.RequestContextMapper;
import com.liferay.segments.model.SegmentsExperienceModel;
import com.liferay.segments.provider.SegmentsEntryProvider;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.segments.simulator.SegmentsEntrySimulator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.segments.internal.configuration.SegmentsServiceConfiguration"}, property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class SegmentsServicePreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsServicePreAction.class);
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private SegmentsEntryProvider _segmentsEntryProvider;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private volatile SegmentsEntrySimulator _segmentsEntrySimulator;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    private SegmentsServiceConfiguration _segmentsServiceConfiguration;

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        try {
            this.doRun(request);
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._segmentsServiceConfiguration = (SegmentsServiceConfiguration)ConfigurableUtil.createConfigurable(SegmentsServiceConfiguration.class, properties);
    }

    protected void doRun(HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isLifecycleRender()) {
            return;
        }
        long[] segmentsEntryIds = new long[]{};
        Layout layout = themeDisplay.getLayout();
        if (this._segmentsServiceConfiguration.segmentationEnabled() && !layout.isTypeControlPanel()) {
            segmentsEntryIds = this._getSegmentsEntryIds(request, themeDisplay.getScopeGroupId(), themeDisplay.getUserId());
        }
        segmentsEntryIds = ArrayUtil.append((long[])segmentsEntryIds, (long)0L);
        request.setAttribute("SEGMENTS_ENTRY_IDS", (Object)segmentsEntryIds);
        long[] segmentsExperienceIds = this._getSegmentsExperienceIds(layout.getGroupId(), segmentsEntryIds, this._portal.getClassNameId(Layout.class.getName()), layout.getPlid());
        request.setAttribute("SEGMENTS_EXPERIENCE_IDS", (Object)ArrayUtil.append((long[])segmentsExperienceIds, (long)0L));
    }

    private long[] _getSegmentsEntryIds(HttpServletRequest request, long groupId, long userId) {
        if (this._segmentsEntrySimulator != null && this._segmentsEntrySimulator.isSimulationActive(userId)) {
            return this._segmentsEntrySimulator.getSimulatedSegmentsEntryIds(userId);
        }
        try {
            return this._segmentsEntryProvider.getSegmentsEntryIds(groupId, User.class.getName(), userId, this._requestContextMapper.map(request));
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)pe.getMessage());
            }
            return new long[0];
        }
    }

    private long[] _getSegmentsExperienceIds(long groupId, long[] segmentsEntryIds, long classNameId, long classPK) {
        List segmentsExperiences = this._segmentsExperienceLocalService.getSegmentsExperiences(groupId, segmentsEntryIds, classNameId, classPK, true, -1, -1, null);
        Stream stream = segmentsExperiences.stream();
        return stream.mapToLong(SegmentsExperienceModel::getSegmentsExperienceId).toArray();
    }
}

