/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.context;

import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.DeviceDetectionUtil;
import com.liferay.portal.kernel.mobile.device.Dimensions;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.context.Context;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={RequestContextMapper.class})
public class RequestContextMapper {
    @Reference
    private BrowserSniffer _browserSniffer;
    @Reference
    private Portal _portal;

    public Context map(HttpServletRequest request) {
        Context context = new Context();
        context.put("browser", (Serializable)((Object)this._browserSniffer.getBrowserId(request)));
        context.put("cookies", (Serializable)this._getCookies(request));
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Device device = DeviceDetectionUtil.detectDevice((HttpServletRequest)request);
        Dimensions screenResolution = null;
        if (device != null && !Objects.equals(device, UnknownDevice.getInstance())) {
            context.put("deviceBrand", (Serializable)((Object)device.getBrand()));
            context.put("deviceModel", (Serializable)((Object)device.getModel()));
            screenResolution = device.getScreenResolution();
        } else {
            context.put("deviceBrand", (Serializable)((Object)""));
            context.put("deviceModel", (Serializable)((Object)""));
            screenResolution = Dimensions.UNKNOWN;
        }
        context.put("deviceScreenResolutionHeight", (Serializable)Double.valueOf(screenResolution.getHeight()));
        context.put("deviceScreenResolutionWidth", (Serializable)Double.valueOf(screenResolution.getWidth()));
        context.put("languageId", (Serializable)((Object)themeDisplay.getLanguageId()));
        User user = themeDisplay.getUser();
        if (user != null && user.getLastLoginDate() != null) {
            Date lastLoginDate = user.getLastLoginDate();
            context.put("lastSignInDateTime", (Serializable)ZonedDateTime.ofInstant(lastLoginDate.toInstant(), ZoneOffset.UTC));
        } else {
            context.put("lastSignInDateTime", (Serializable)ZonedDateTime.of(LocalDateTime.MIN, ZoneOffset.UTC));
        }
        context.put("localDate", (Serializable)LocalDate.from(ZonedDateTime.now()));
        context.put("referrerURL", (Serializable)((Object)GetterUtil.getString((String)request.getHeader("Referer"))));
        context.put("signedIn", (Serializable)Boolean.valueOf(themeDisplay.isSignedIn()));
        context.put("url", (Serializable)((Object)this._portal.getCurrentCompleteURL(request)));
        String userAgent = GetterUtil.getString((String)request.getHeader("User-Agent"));
        context.put("userAgent", (Serializable)((Object)userAgent));
        return context;
    }

    private String[] _getCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return new String[0];
        }
        return (String[])Stream.of(cookies).map((? super T c) -> c.getName() + "=" + c.getValue()).toArray(String[]::new);
    }
}

