/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.asah.client.data.binding;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.liferay.segments.internal.asah.client.model.PageMetadata;
import com.liferay.segments.internal.asah.client.model.Results;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AsahFaroBackendJSONObjectMapper {
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
    };

    public static <T> T map(String json, Class<T> clazz) throws IOException {
        return (T)_objectMapper.readValue(json, clazz);
    }

    public static <T> Results<T> mapToResults(String json, String embeddedRelName, Class<T> clazz) throws IOException {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        ObjectReader objectReader = _objectMapper.readerFor((JavaType)typeFactory.constructCollectionType(ArrayList.class, clazz));
        JsonNode responseJsonNode = _objectMapper.readTree(json);
        JsonNode embeddedJsonNode = responseJsonNode.get("_embedded");
        List items = Collections.emptyList();
        if (embeddedJsonNode != null) {
            JsonNode embeddedRelJsonNode = embeddedJsonNode.get(embeddedRelName);
            items = (List)objectReader.readValue(embeddedRelJsonNode);
        }
        JsonNode pageJsonNode = responseJsonNode.get("page");
        PageMetadata pageMetadata = (PageMetadata)_objectMapper.treeToValue((TreeNode)pageJsonNode, PageMetadata.class);
        return new Results(items, (int)pageMetadata.getTotalElements());
    }

    private AsahFaroBackendJSONObjectMapper() {
    }
}

