/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.asah.client;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.liferay.segments.internal.asah.client.JSONWebServiceClient;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JSONWebServiceClient.class})
public class JSONWebServiceClientImpl
implements JSONWebServiceClient {
    private String _baseURI;
    private Client _client;
    @Reference
    private ClientBuilder _clientBuilder;

    @Override
    public String doGet(String url, MultivaluedMap<String, Object> parameters, Map<String, String> headers) {
        WebTarget webTarget = this._client.target(this._baseURI);
        webTarget = webTarget.path(url);
        for (Object entry : parameters.entrySet()) {
            for (Object value : (List)entry.getValue()) {
                webTarget = webTarget.queryParam((String)entry.getKey(), new Object[]{value});
            }
        }
        Invocation.Builder builder = webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        for (Map.Entry entry : headers.entrySet()) {
            builder.header((String)entry.getKey(), entry.getValue());
        }
        Response response = builder.get();
        this._validateResponse(response);
        return (String)response.readEntity(String.class);
    }

    @Override
    public String getBaseURI() {
        return this._baseURI;
    }

    @Override
    public void setBaseURI(String baseURI) {
        this._baseURI = baseURI;
    }

    @Activate
    protected void activate() {
        this._client = this._clientBuilder.build();
        this._client.register(JacksonJsonProvider.class);
    }

    private void _validateResponse(Response response) {
        int status = response.getStatus();
        if (status < 200 || status >= 300) {
            throw new ClientErrorException("Unexpected response status: " + status, status);
        }
    }
}

