/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.asah.client;

import com.liferay.portal.kernel.exception.NestableRuntimeException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.segments.internal.asah.client.AsahFaroBackendClient;
import com.liferay.segments.internal.asah.client.JSONWebServiceClient;
import com.liferay.segments.internal.asah.client.data.binding.IndividualJSONObjectMapper;
import com.liferay.segments.internal.asah.client.data.binding.IndividualSegmentJSONObjectMapper;
import com.liferay.segments.internal.asah.client.model.Individual;
import com.liferay.segments.internal.asah.client.model.IndividualSegment;
import com.liferay.segments.internal.asah.client.model.Results;
import com.liferay.segments.internal.asah.client.util.FilterBuilder;
import com.liferay.segments.internal.asah.client.util.OrderByField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class AsahFaroBackendClientImpl
implements AsahFaroBackendClient {
    private static final String _PATH_INDIVIDUAL_SEGMENTS = "api/1.0/individual-segments";
    private static final String _PATH_INDIVIDUAL_SEGMENTS_INDIVIDUALS = "api/1.0/individual-segments/{id}/individuals";
    private static final IndividualJSONObjectMapper _individualJSONObjectMapper = new IndividualJSONObjectMapper();
    private static final IndividualSegmentJSONObjectMapper _individualSegmentJSONObjectMapper = new IndividualSegmentJSONObjectMapper();
    private final String _dataSourceId;
    private final Map<String, String> _headers = new HashMap<String, String>();
    private final JSONWebServiceClient _jsonWebServiceClient;

    public AsahFaroBackendClientImpl(JSONWebServiceClient jsonWebServiceClient, String asahFaroBackendDataSourceId, String asahFaroBackendSecuritySignature, String asahFaroBackendURL) {
        this._jsonWebServiceClient = jsonWebServiceClient;
        this._dataSourceId = asahFaroBackendDataSourceId;
        this._headers.put("OSB-Asah-Faro-Backend-Security-Signature", asahFaroBackendSecuritySignature);
        this._jsonWebServiceClient.setBaseURI(asahFaroBackendURL);
    }

    @Override
    public String getDataSourceId() {
        return this._dataSourceId;
    }

    @Override
    public Results<Individual> getIndividualResults(String individualSegmentId, int cur, int delta, List<OrderByField> orderByFields) {
        FilterBuilder filterBuilder = new FilterBuilder();
        filterBuilder.addNullFilter("dataSourceIndividualPKs/" + this._dataSourceId, " ne ");
        try {
            String response = this._jsonWebServiceClient.doGet(StringUtil.replace((String)_PATH_INDIVIDUAL_SEGMENTS_INDIVIDUALS, (String)"{id}", (String)individualSegmentId), this._getParameters(filterBuilder, "demographics/?/value", cur, delta, orderByFields), this._headers);
            return _individualJSONObjectMapper.mapToResults(response);
        }
        catch (IOException ioe) {
            throw new NestableRuntimeException("Unable to handle JSON response: " + ioe.getMessage(), (Throwable)ioe);
        }
    }

    @Override
    public Results<IndividualSegment> getIndividualSegmentResults(int cur, int delta, List<OrderByField> orderByFields) {
        FilterBuilder filterBuilder = new FilterBuilder();
        filterBuilder.addFilter("individualCount", " ge ", 1);
        filterBuilder.addFilter("status", " eq ", IndividualSegment.Status.ACTIVE.name());
        try {
            String response = this._jsonWebServiceClient.doGet(_PATH_INDIVIDUAL_SEGMENTS, this._getParameters(filterBuilder, "fields/?/value", cur, delta, orderByFields), this._headers);
            return _individualSegmentJSONObjectMapper.mapToResults(response);
        }
        catch (IOException ioe) {
            throw new NestableRuntimeException("Unable to handle JSON response: " + ioe.getMessage(), (Throwable)ioe);
        }
    }

    private MultivaluedMap<String, Object> _getParameters(FilterBuilder filterBuilder, String fieldNameContext, int cur, int delta, List<OrderByField> orderByFields) {
        MultivaluedMap<String, Object> uriVariables = this._getUriVariables(cur, delta, orderByFields, fieldNameContext);
        uriVariables.putSingle((Object)"filter", (Object)filterBuilder.build());
        return uriVariables;
    }

    private MultivaluedMap<String, Object> _getUriVariables(int cur, int delta, List<OrderByField> orderByFields, String fieldNameContext) {
        MultivaluedHashMap uriVariables = new MultivaluedHashMap();
        uriVariables.putSingle((Object)"page", (Object)(cur - 1));
        uriVariables.putSingle((Object)"size", (Object)delta);
        if (orderByFields == null || orderByFields.isEmpty()) {
            return uriVariables;
        }
        ArrayList<String> sort = new ArrayList<String>();
        for (OrderByField orderByField : orderByFields) {
            String fieldName = orderByField.getFieldName();
            if (!orderByField.isSystem() && fieldNameContext != null) {
                fieldName = StringUtil.replace((String)fieldNameContext, (char)'?', (String)fieldName);
            }
            sort.add(fieldName + "," + orderByField.getOrderBy());
        }
        uriVariables.put((Object)"sort", sort);
        return uriVariables;
    }
}

