/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.search.experiences.exception.SXPElementReadOnlyException;
import com.liferay.search.experiences.model.SXPElement;
import com.liferay.search.experiences.service.base.SXPElementServiceBaseImpl;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"json.web.service.context.name=sxp", "json.web.service.context.path=SXPElement"}, service={AopService.class})
public class SXPElementServiceImpl
extends SXPElementServiceBaseImpl {
    @Reference(target="(resource.name=com.liferay.search.experiences)")
    private volatile PortletResourcePermission _portletResourcePermission;
    @Reference(target="(model.class.name=com.liferay.search.experiences.model.SXPElement)")
    private volatile ModelResourcePermission<SXPElement> _sxpElementModelResourcePermission;

    public SXPElement addSXPElement(String externalReferenceCode, Map<Locale, String> descriptionMap, String elementDefinitionJSON, String fallbackDescription, String fallbackTitle, boolean readOnly, String schemaVersion, Map<Locale, String> titleMap, int type, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_SXP_ELEMENT");
        return this.sxpElementLocalService.addSXPElement(externalReferenceCode, this.getUserId(), descriptionMap, elementDefinitionJSON, fallbackDescription, fallbackTitle, readOnly, schemaVersion, titleMap, type, serviceContext);
    }

    public SXPElement deleteSXPElement(long sxpElementId) throws PortalException {
        this._sxpElementModelResourcePermission.check(this.getPermissionChecker(), sxpElementId, "DELETE");
        SXPElement sxpElement = this.sxpElementPersistence.findByPrimaryKey(sxpElementId);
        if (sxpElement.isReadOnly()) {
            throw new SXPElementReadOnlyException(StringBundler.concat((Object[])new Object[]{"Search experiences element ", sxpElementId, " is read-only"}));
        }
        return this.sxpElementLocalService.deleteSXPElement(sxpElement);
    }

    public SXPElement fetchSXPElement(long sxpElementId) throws PortalException {
        SXPElement sxpElement = this.sxpElementLocalService.fetchSXPElement(sxpElementId);
        if (sxpElement != null) {
            this._sxpElementModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)sxpElement, "VIEW");
        }
        return sxpElement;
    }

    public SXPElement fetchSXPElementByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        SXPElement sxpElement = this.sxpElementLocalService.fetchSXPElementByExternalReferenceCode(externalReferenceCode, companyId);
        if (sxpElement != null) {
            this._sxpElementModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)sxpElement, "VIEW");
        }
        return sxpElement;
    }

    public SXPElement getSXPElement(long sxpElementId) throws PortalException {
        SXPElement sxpElement = this.sxpElementLocalService.getSXPElement(sxpElementId);
        this._sxpElementModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)sxpElement, "VIEW");
        return sxpElement;
    }

    public SXPElement getSXPElementByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        SXPElement sxpElement = this.sxpElementLocalService.getSXPElementByExternalReferenceCode(externalReferenceCode, companyId);
        this._sxpElementModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)sxpElement, "VIEW");
        return sxpElement;
    }

    public SXPElement updateSXPElement(String externalReferenceCode, long sxpElementId, Map<Locale, String> descriptionMap, String elementDefinitionJSON, String schemaVersion, boolean hidden, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        SXPElement sxpElement = this.sxpElementPersistence.findByPrimaryKey(sxpElementId);
        if (sxpElement.isReadOnly()) {
            throw new SXPElementReadOnlyException(StringBundler.concat((Object[])new Object[]{"Search experiences element ", sxpElementId, " is read-only"}));
        }
        this._sxpElementModelResourcePermission.check(this.getPermissionChecker(), sxpElementId, "UPDATE");
        return this.sxpElementLocalService.updateSXPElement(externalReferenceCode, this.getUserId(), sxpElementId, descriptionMap, elementDefinitionJSON, hidden, schemaVersion, titleMap, serviceContext);
    }
}

