/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.search.experiences.exception.SXPElementTitleException;
import com.liferay.search.experiences.model.SXPElement;
import com.liferay.search.experiences.service.base.SXPElementLocalServiceBaseImpl;
import com.liferay.search.experiences.validator.SXPElementValidator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.search.experiences.model.SXPElement"}, service={AopService.class})
public class SXPElementLocalServiceImpl
extends SXPElementLocalServiceBaseImpl {
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SXPElementValidator _sxpElementValidator;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public SXPElement addSXPElement(String externalReferenceCode, long userId, Map<Locale, String> descriptionMap, String elementDefinitionJSON, String fallbackDescription, String fallbackTitle, boolean readOnly, String schemaVersion, Map<Locale, String> titleMap, int type, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)fallbackDescription)) {
            fallbackDescription = descriptionMap.get(LocaleUtil.getDefault());
        }
        if (Validator.isNull((String)fallbackTitle)) {
            fallbackTitle = titleMap.get(LocaleUtil.getDefault());
        }
        this._validate(titleMap, type, serviceContext);
        SXPElement sxpElement = this.createSXPElement(this.counterLocalService.increment(SXPElement.class.getName()));
        sxpElement.setExternalReferenceCode(externalReferenceCode);
        User user = this._userLocalService.getUser(userId);
        sxpElement.setCompanyId(user.getCompanyId());
        sxpElement.setUserId(user.getUserId());
        sxpElement.setUserName(user.getFullName());
        sxpElement.setDescriptionMap(descriptionMap);
        sxpElement.setElementDefinitionJSON(elementDefinitionJSON);
        sxpElement.setFallbackDescription(fallbackDescription);
        sxpElement.setFallbackTitle(fallbackTitle);
        sxpElement.setHidden(false);
        sxpElement.setReadOnly(readOnly);
        sxpElement.setSchemaVersion(schemaVersion);
        sxpElement.setTitleMap(titleMap);
        sxpElement.setType(type);
        sxpElement.setVersion(String.format("%.1f", (double)GetterUtil.getFloat((String)sxpElement.getVersion(), (float)0.9f) + 0.1));
        sxpElement.setStatus(0);
        sxpElement = (SXPElement)this.sxpElementPersistence.update((BaseModel)sxpElement);
        this._resourceLocalService.addModelResources((AuditedModel)sxpElement, serviceContext);
        return sxpElement;
    }

    public void deleteCompanySXPElements(long companyId) throws PortalException {
        List sxpElements = this.sxpElementPersistence.findByCompanyId(companyId);
        for (SXPElement sxpElement : sxpElements) {
            this.sxpElementLocalService.deleteSXPElement(sxpElement);
        }
    }

    @Override
    public SXPElement deleteSXPElement(long sxpElementId) throws PortalException {
        SXPElement sxpElement = this.sxpElementPersistence.findByPrimaryKey(sxpElementId);
        return this.deleteSXPElement(sxpElement);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public SXPElement deleteSXPElement(SXPElement sxpElement) throws PortalException {
        sxpElement = (SXPElement)this.sxpElementPersistence.remove((BaseModel)sxpElement);
        this._resourceLocalService.deleteResource((AuditedModel)sxpElement, 4);
        return sxpElement;
    }

    public List<SXPElement> getSXPElements(long companyId, boolean readOnly) {
        return this.sxpElementPersistence.findByC_R(companyId, readOnly);
    }

    @Indexable(type=IndexableType.REINDEX)
    public SXPElement updateStatus(long userId, long sxpElementId, int status) throws PortalException {
        SXPElement sxpElement = this.sxpElementPersistence.findByPrimaryKey(sxpElementId);
        if (sxpElement.getStatus() == status) {
            return sxpElement;
        }
        sxpElement.setStatus(status);
        return (SXPElement)this.sxpElementPersistence.update((BaseModel)sxpElement);
    }

    @Indexable(type=IndexableType.REINDEX)
    public SXPElement updateSXPElement(String externalReferenceCode, long userId, long sxpElementId, Map<Locale, String> descriptionMap, String elementDefinitionJSON, boolean hidden, String schemaVersion, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        SXPElement sxpElement = this.getSXPElement(sxpElementId);
        this._validate(titleMap, sxpElement.getType(), serviceContext);
        sxpElement.setExternalReferenceCode(externalReferenceCode);
        sxpElement.setDescriptionMap(descriptionMap);
        sxpElement.setElementDefinitionJSON(elementDefinitionJSON);
        sxpElement.setHidden(hidden);
        sxpElement.setSchemaVersion(schemaVersion);
        sxpElement.setTitleMap(titleMap);
        sxpElement.setVersion(String.format("%.1f", (double)GetterUtil.getFloat((String)sxpElement.getVersion(), (float)0.9f) + 0.1));
        return this.updateSXPElement(sxpElement);
    }

    private void _validate(Map<Locale, String> titleMap, int type, ServiceContext serviceContext) throws SXPElementTitleException {
        if (GetterUtil.getBoolean((Object)serviceContext.getAttribute(SXPElementLocalServiceImpl.class.getName() + "#_validate"), (boolean)true)) {
            this._sxpElementValidator.validate(titleMap, type);
        }
    }
}

