/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.search.experiences.model.SXPElement;
import com.liferay.search.experiences.service.SXPElementLocalService;
import com.liferay.search.experiences.service.persistence.SXPElementPersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class SXPElementLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
SXPElementLocalService {
    protected SXPElementLocalService sxpElementLocalService;
    @Reference
    protected SXPElementPersistence sxpElementPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(SXPElementLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public SXPElement addSXPElement(SXPElement sxpElement) {
        sxpElement.setNew(true);
        return (SXPElement)this.sxpElementPersistence.update((BaseModel)sxpElement);
    }

    @Transactional(enabled=false)
    public SXPElement createSXPElement(long sxpElementId) {
        return this.sxpElementPersistence.create(sxpElementId);
    }

    @Indexable(type=IndexableType.DELETE)
    public SXPElement deleteSXPElement(long sxpElementId) throws PortalException {
        return this.sxpElementPersistence.remove(sxpElementId);
    }

    @Indexable(type=IndexableType.DELETE)
    public SXPElement deleteSXPElement(SXPElement sxpElement) throws PortalException {
        return (SXPElement)this.sxpElementPersistence.remove((BaseModel)sxpElement);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.sxpElementPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(SXPElement.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.sxpElementPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.sxpElementPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.sxpElementPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.sxpElementPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.sxpElementPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public SXPElement fetchSXPElement(long sxpElementId) {
        return this.sxpElementPersistence.fetchByPrimaryKey(sxpElementId);
    }

    public SXPElement fetchSXPElementByUuidAndCompanyId(String uuid, long companyId) {
        return this.sxpElementPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public SXPElement fetchSXPElementByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.sxpElementPersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public SXPElement getSXPElementByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.sxpElementPersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public SXPElement getSXPElement(long sxpElementId) throws PortalException {
        return this.sxpElementPersistence.findByPrimaryKey(sxpElementId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.sxpElementLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(SXPElement.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("sxpElementId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.sxpElementLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(SXPElement.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("sxpElementId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.sxpElementLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(SXPElement.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("sxpElementId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<SXPElement>(){

            public void performAction(SXPElement sxpElement) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)sxpElement);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)SXPElement.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.sxpElementPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement SXPElementLocalServiceImpl#deleteSXPElement(SXPElement) to avoid orphaned data");
        }
        return this.sxpElementLocalService.deleteSXPElement((SXPElement)persistedModel);
    }

    public BasePersistence<SXPElement> getBasePersistence() {
        return this.sxpElementPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.sxpElementPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public SXPElement getSXPElementByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.sxpElementPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<SXPElement> getSXPElements(int start, int end) {
        return this.sxpElementPersistence.findAll(start, end);
    }

    public int getSXPElementsCount() {
        return this.sxpElementPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public SXPElement updateSXPElement(SXPElement sxpElement) {
        return (SXPElement)this.sxpElementPersistence.update((BaseModel)sxpElement);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{SXPElementLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.sxpElementLocalService = (SXPElementLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return SXPElementLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return SXPElement.class;
    }

    protected String getModelClassName() {
        return SXPElement.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.sxpElementPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

