/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.search.experiences.internal.model.listener.CompanyModelListener;
import com.liferay.search.experiences.rest.dto.v1_0.SXPElement;
import com.liferay.search.experiences.service.SXPElementLocalService;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SXPElementUtil {
    private static final String _SCHEMA_VERSION = StringUtil.replace((String)StringUtil.extractFirst((String)StringUtil.extractLast((String)SXPElement.class.getName(), (String)".v"), (char)'.'), (char)'_', (char)'.');
    private static List<SXPElement> _sxpElements;

    public static void addSXPElements(final Company company, SXPElementLocalService sxpElementLocalService) throws PortalException {
        HashSet<String> externalReferenceCodes = new HashSet<String>();
        for (com.liferay.search.experiences.model.SXPElement sXPElement : sxpElementLocalService.getSXPElements(company.getCompanyId(), true)) {
            externalReferenceCodes.add(sXPElement.getExternalReferenceCode());
        }
        for (SXPElement sXPElement : SXPElementUtil._getOrCreateSXPElements()) {
            if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-122920") && Objects.equals(sXPElement.getExternalReferenceCode(), "RESCORE_BY_TEXT_EMBEDDING") || externalReferenceCodes.contains(sXPElement.getExternalReferenceCode())) continue;
            final User user = company.getGuestUser();
            sxpElementLocalService.addSXPElement(sXPElement.getExternalReferenceCode(), user.getUserId(), LocalizedMapUtil.getLocalizedMap((Map)sXPElement.getDescription_i18n(), (boolean)true), String.valueOf(sXPElement.getElementDefinition()), (String)sXPElement.getDescription_i18n().get(LocaleUtil.US.toString()), (String)sXPElement.getTitle_i18n().get(LocaleUtil.US.toString()), true, _SCHEMA_VERSION, LocalizedMapUtil.getLocalizedMap((Map)sXPElement.getTitle_i18n(), (boolean)true), 0, new ServiceContext(){
                {
                    this.setAddGuestPermissions(true);
                    this.setCompanyId(company.getCompanyId());
                    this.setScopeGroupId(company.getGroupId());
                    this.setUserId(user.getUserId());
                }
            });
        }
    }

    private static List<SXPElement> _createSXPElements() {
        try {
            ArrayList<SXPElement> sxpElements = new ArrayList<SXPElement>();
            Bundle bundle = FrameworkUtil.getBundle(CompanyModelListener.class);
            Package pkg = CompanyModelListener.class.getPackage();
            String path = StringUtil.replace((String)pkg.getName(), (char)'.', (char)'/');
            Enumeration enumeration = bundle.findEntries(path.concat("/dependencies"), "*.json", false);
            while (enumeration.hasMoreElements()) {
                sxpElements.add(com.liferay.search.experiences.rest.dto.v1_0.util.SXPElementUtil.toSXPElement((String)URLUtil.toString((URL)((URL)enumeration.nextElement()))));
            }
            return sxpElements;
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
    }

    private static List<SXPElement> _getOrCreateSXPElements() {
        if (_sxpElements == null) {
            _sxpElements = SXPElementUtil._createSXPElements();
        }
        return _sxpElements;
    }
}

