/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.upgrade.v3_1_4;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.search.experiences.rest.dto.v1_0.ElementInstance;
import com.liferay.search.experiences.rest.dto.v1_0.SXPElement;
import com.liferay.search.experiences.rest.dto.v1_0.util.ElementInstanceUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SXPBlueprintAndSXPElementUpgradeProcess
extends UpgradeProcess {
    private static final String[] _EXTERNAL_REFERENCE_CODES = new String[]{"BOOST_CONTENTS_IN_A_CATEGORY", "BOOST_CONTENTS_IN_A_CATEGORY_BY_KEYWORD_MATCH", "BOOST_CONTENTS_IN_A_CATEGORY_FOR_A_PERIOD_OF_TIME", "BOOST_CONTENTS_IN_A_CATEGORY_FOR_GUEST_USERS", "BOOST_CONTENTS_IN_A_CATEGORY_FOR_NEW_USER_ACCOUNTS", "BOOST_CONTENTS_IN_A_CATEGORY_FOR_THE_TIME_OF_DAY", "BOOST_CONTENTS_IN_A_CATEGORY_FOR_USER_SEGMENTS", "HIDE_CONTENTS_IN_A_CATEGORY", "HIDE_CONTENTS_IN_A_CATEGORY_FOR_GUEST_USERS"};
    private static final Log _log = LogFactoryUtil.getLog(SXPBlueprintAndSXPElementUpgradeProcess.class);
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final GroupLocalService _groupLocalService;
    private final JSONFactory _jsonFactory;

    public SXPBlueprintAndSXPElementUpgradeProcess(AssetCategoryLocalService assetCategoryLocalService, GroupLocalService groupLocalService, JSONFactory jsonFactory) {
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._groupLocalService = groupLocalService;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select sxpBlueprintId, elementInstancesJSON from SXPBlueprint");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPBlueprint set elementInstancesJSON = ? where sxpBlueprintId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                this._upgradeSXPBlueprint(preparedStatement2, resultSet);
            }
            preparedStatement2.executeBatch();
        }
        try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update SXPElement set elementDefinitionJSON = ? where externalReferenceCode = ?");){
            for (String externalReferenceCode : _EXTERNAL_REFERENCE_CODES) {
                preparedStatement.setString(1, StringUtil.read(((Object)((Object)this)).getClass(), (String)("dependencies/" + StringUtil.toLowerCase((String)externalReferenceCode) + ".json")));
                preparedStatement.setString(2, externalReferenceCode);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }

    private JSONArray _createExternalReferencesCodesJSONArray(long[] assetCategoryIds) throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (long assetCategoryId : assetCategoryIds) {
            jsonArray.put(this._getExternalReferenceCode(assetCategoryId));
        }
        return jsonArray;
    }

    private JSONObject _createGroupAssetCategoryExternalReferenceCodesJSONObject(JSONObject assetCategoryIdJSONObject) throws Exception {
        long assetCategoryId = assetCategoryIdJSONObject.getLong("value");
        return JSONUtil.put((String)"label", (Object)this._getLabel(assetCategoryId)).put("value", this._getExternalReferenceCode(assetCategoryId));
    }

    private String _fixElementInstancesJSON(String elementInstancesJSON) throws Exception {
        JSONArray elementInstancesJSONArray = this._jsonFactory.createJSONArray(elementInstancesJSON);
        for (int i = 0; i < elementInstancesJSONArray.length(); ++i) {
            JSONObject elementInstanceJSONObject = elementInstancesJSONArray.getJSONObject(i);
            JSONObject sxpElementJSONObject = elementInstanceJSONObject.getJSONObject("sxpElement");
            String externalReferenceCode = sxpElementJSONObject.getString("externalReferenceCode");
            if (!ArrayUtil.contains((Object[])_EXTERNAL_REFERENCE_CODES, (Object)externalReferenceCode)) continue;
            this._upgradeConfigurationEntry(elementInstanceJSONObject, externalReferenceCode);
            this._upgradeElementDefinition(elementInstanceJSONObject);
            this._upgradeUIConfigurationValues(elementInstanceJSONObject);
        }
        return elementInstancesJSONArray.toString();
    }

    private long[] _getAssetCategoryIds(JSONObject termJSONObject) {
        long[] assetCategoryIds = null;
        Object object = JSONUtil.getValue((Object)termJSONObject, (String[])new String[]{"Object/assetCategoryIds"});
        assetCategoryIds = object instanceof JSONArray ? JSONUtil.toLongArray((JSONArray)((JSONArray)object)) : new long[]{JSONUtil.getValueAsLong((Object)object, (String[])new String[]{"Object/value"})};
        return assetCategoryIds;
    }

    private String _getExternalReferenceCode(long assetCategoryId) throws Exception {
        try {
            AssetCategory assetCategory = this._assetCategoryLocalService.getAssetCategory(assetCategoryId);
            Group group = this._groupLocalService.getGroup(assetCategory.getGroupId());
            return group.getExternalReferenceCode() + "&&" + assetCategory.getExternalReferenceCode();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get external reference code for asset category ID " + assetCategoryId), (Throwable)exception);
            }
            throw exception;
        }
    }

    private String _getLabel(long assetCategoryId) throws Exception {
        try {
            AssetCategory assetCategory = this._assetCategoryLocalService.getAssetCategory(assetCategoryId);
            return StringBundler.concat((String[])new String[]{assetCategory.getName(), " (ERC: ", assetCategory.getExternalReferenceCode(), ")"});
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get asset category " + assetCategoryId));
            }
            throw exception;
        }
    }

    private boolean _hasAssetCategoryElement(ElementInstance[] elementInstances) {
        for (ElementInstance elementInstance : elementInstances) {
            SXPElement sxpElement = elementInstance.getSxpElement();
            if (!ArrayUtil.contains((Object[])_EXTERNAL_REFERENCE_CODES, (Object)sxpElement.getExternalReferenceCode())) continue;
            return true;
        }
        return false;
    }

    private void _upgradeConfigurationEntry(JSONObject elementInstanceJSONObject, String externalReferenceCode) throws Exception {
        JSONObject queryJSONObject = JSONUtil.getValueAsJSONObject((Object)elementInstanceJSONObject, (String[])new String[]{"JSONObject/configurationEntry", "JSONObject/queryConfiguration", "JSONArray/queryEntries", "JSONObject/0", "JSONArray/clauses", "JSONObject/0", "JSONObject/query"});
        if (externalReferenceCode.startsWith("BOOST_CONTENTS_IN_A_CATEGORY")) {
            this._upgradeConfigurationEntryForBoostElements(queryJSONObject);
        } else if (externalReferenceCode.startsWith("HIDE_CONTENTS_IN_A_CATEGORY")) {
            this._upgradeConfigurationEntryForHideElements(queryJSONObject);
        }
    }

    private void _upgradeConfigurationEntryForBoostElements(JSONObject queryJSONObject) throws Exception {
        long[] assetCategoryIds = null;
        double boost = 0.0;
        if (queryJSONObject.has("term")) {
            JSONObject termJSONObject = queryJSONObject.getJSONObject("term");
            queryJSONObject.remove("term");
            JSONObject assetCategoryIdsJSONObject = termJSONObject.getJSONObject("assetCategoryIds");
            assetCategoryIds = this._getAssetCategoryIds(termJSONObject);
            boost = assetCategoryIdsJSONObject.getDouble("boost");
        } else {
            JSONObject termsJSONObject = queryJSONObject.getJSONObject("terms");
            assetCategoryIds = this._getAssetCategoryIds(termsJSONObject);
            boost = termsJSONObject.getDouble("boost");
        }
        queryJSONObject.put("terms", JSONUtil.put((String)"boost", (Object)boost).put("groupAssetCategoryExternalReferenceCodes", this._createExternalReferencesCodesJSONArray(assetCategoryIds)));
    }

    private void _upgradeConfigurationEntryForHideElements(JSONObject queryJSONObject) throws Exception {
        JSONObject mustNotJSONObject = JSONUtil.getValueAsJSONObject((Object)queryJSONObject, (String[])new String[]{"JSONObject/bool", "JSONArray/must_not", "JSONObject/0"});
        mustNotJSONObject.put("terms", JSONUtil.put((String)"groupAssetCategoryExternalReferenceCodes", (Object)this._createExternalReferencesCodesJSONArray(this._getAssetCategoryIds(mustNotJSONObject.getJSONObject("term"))))).remove("term");
    }

    private void _upgradeElementDefinition(JSONObject elementInstanceJSONObject) {
        int i;
        JSONObject queryJSONObject = JSONUtil.getValueAsJSONObject((Object)elementInstanceJSONObject, (String[])new String[]{"JSONObject/sxpElement", "JSONObject/elementDefinition", "JSONObject/configuration", "JSONObject/queryConfiguration", "JSONArray/queryEntries", "JSONObject/0", "JSONArray/clauses", "JSONObject/0", "JSONObject/query"});
        if (queryJSONObject.has("bool")) {
            JSONArray mustNotJSONArray = JSONUtil.getValueAsJSONArray((Object)queryJSONObject, (String[])new String[]{"JSONObject/bool", "JSONArray/must_not"});
            for (i = 0; i < mustNotJSONArray.length(); ++i) {
                JSONObject mustNotJSONObject = mustNotJSONArray.getJSONObject(i);
                if (!mustNotJSONObject.has("term")) continue;
                mustNotJSONObject.put("terms", JSONUtil.put((String)"groupAssetCategoryExternalReferenceCodes", (Object)"${configuration.group_asset_category_external_reference_codes}")).remove("term");
                break;
            }
        } else {
            queryJSONObject.put("terms", JSONUtil.put((String)"boost", (Object)"${configuration.boost}").put("groupAssetCategoryExternalReferenceCodes", "${configuration.group_asset_category_external_reference_codes}")).remove("term");
        }
        JSONArray fieldsJSONArray = JSONUtil.getValueAsJSONArray((Object)elementInstanceJSONObject, (String[])new String[]{"JSONObject/sxpElement", "JSONObject/elementDefinition", "JSONObject/uiConfiguration", "JSONArray/fieldSets", "JSONObject/0", "JSONArray/fields"});
        for (i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            String fieldName = fieldJSONObject.getString("name");
            if (!fieldName.startsWith("asset_category_id")) continue;
            fieldJSONObject.put("label", "asset-category-external-reference-codes").put("name", "group_asset_category_external_reference_codes").put("type", "multiselect").remove("labelLocalized");
            break;
        }
    }

    private void _upgradeSXPBlueprint(PreparedStatement preparedStatement2, ResultSet resultSet) throws SQLException {
        block3: {
            try {
                String elementInstancesJSON = resultSet.getString("elementInstancesJSON");
                ElementInstance[] elementInstances = ElementInstanceUtil.toElementInstances((String)elementInstancesJSON);
                if (elementInstances == null || !this._hasAssetCategoryElement(elementInstances)) {
                    return;
                }
                preparedStatement2.setString(1, this._fixElementInstancesJSON(elementInstancesJSON));
                preparedStatement2.setLong(2, resultSet.getLong("sxpBlueprintId"));
                preparedStatement2.addBatch();
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block3;
                _log.info((Object)("Unable to upgrade search experiences blueprint " + resultSet.getLong("sxpBlueprintId")), (Throwable)exception);
            }
        }
    }

    private void _upgradeUIConfigurationValues(JSONObject elementInstanceJSONObject) throws Exception {
        JSONObject uiConfigurationValuesJSONObject = elementInstanceJSONObject.getJSONObject("uiConfigurationValues");
        JSONArray groupAssetCategoryExternalReferenceCodesJSONArray = this._jsonFactory.createJSONArray();
        if (uiConfigurationValuesJSONObject.has("asset_category_id")) {
            groupAssetCategoryExternalReferenceCodesJSONArray.put(this._createGroupAssetCategoryExternalReferenceCodesJSONObject(uiConfigurationValuesJSONObject.getJSONObject("asset_category_id")));
            uiConfigurationValuesJSONObject.remove("asset_category_id");
        } else {
            JSONArray assetCategoryIdsJSONArray = uiConfigurationValuesJSONObject.getJSONArray("asset_category_ids");
            for (int i = 0; i < assetCategoryIdsJSONArray.length(); ++i) {
                groupAssetCategoryExternalReferenceCodesJSONArray.put(this._createGroupAssetCategoryExternalReferenceCodesJSONObject(assetCategoryIdsJSONArray.getJSONObject(i)));
            }
            uiConfigurationValuesJSONObject.remove("asset_category_ids");
        }
        uiConfigurationValuesJSONObject.put("group_asset_category_external_reference_codes", groupAssetCategoryExternalReferenceCodesJSONArray);
    }
}

