/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.upgrade.v3_1_3;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.search.experiences.rest.dto.v1_0.ElementInstance;
import com.liferay.search.experiences.rest.dto.v1_0.SXPElement;
import com.liferay.search.experiences.rest.dto.v1_0.util.ElementInstanceUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

public class SXPBlueprintAndSXPElementUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(SXPBlueprintAndSXPElementUpgradeProcess.class);
    private final GroupLocalService _groupLocalService;
    private final JSONFactory _jsonFactory;

    public SXPBlueprintAndSXPElementUpgradeProcess(GroupLocalService groupLocalService, JSONFactory jsonFactory) {
        this._groupLocalService = groupLocalService;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select sxpBlueprintId, elementInstancesJSON from SXPBlueprint");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPBlueprint set elementInstancesJSON = ? where sxpBlueprintId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                this._upgradeSXPBlueprint(preparedStatement2, resultSet);
            }
            preparedStatement2.executeBatch();
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update SXPElement set elementDefinitionJSON = ? where externalReferenceCode = 'LIMIT_SEARCH_TO_THESE_SITES'");){
            preparedStatement.setString(1, StringUtil.read(((Object)((Object)this)).getClass(), (String)"dependencies/limit_search_to_these_sites.json"));
            preparedStatement.executeUpdate();
        }
    }

    private String _fixElementInstancesJSON(String elementInstanceJSON) throws Exception {
        if (Validator.isBlank((String)elementInstanceJSON)) {
            return elementInstanceJSON;
        }
        JSONArray elementInstanceJSONArray = this._jsonFactory.createJSONArray(elementInstanceJSON);
        for (int i = 0; i < elementInstanceJSONArray.length(); ++i) {
            String externalReferenceCode;
            JSONObject elementInstanceJSONObject = elementInstanceJSONArray.getJSONObject(i);
            JSONObject sxpElementJSONObject = elementInstanceJSONObject.getJSONObject("sxpElement");
            if (sxpElementJSONObject == null || !Objects.equals(externalReferenceCode = sxpElementJSONObject.getString("externalReferenceCode"), "LIMIT_SEARCH_TO_THESE_SITES")) continue;
            this._upgradeConfigurationEntry(elementInstanceJSONObject);
            this._upgradeElementDefinition(sxpElementJSONObject);
            this._upgradeUIConfigurationValues(elementInstanceJSONObject);
        }
        return elementInstanceJSONArray.toString();
    }

    private boolean _hasLimitSearchToTheseSites(ElementInstance[] elementInstances) {
        for (ElementInstance elementInstance : elementInstances) {
            SXPElement sxpElement = elementInstance.getSxpElement();
            if (!Objects.equals(sxpElement.getExternalReferenceCode(), "LIMIT_SEARCH_TO_THESE_SITES")) continue;
            return true;
        }
        return false;
    }

    private void _upgradeConfigurationEntry(JSONObject elementInstanceJSONObject) throws Exception {
        JSONObject queryJSONObject = JSONUtil.getValueAsJSONObject((Object)elementInstanceJSONObject, (String[])new String[]{"JSONObject/configurationEntry", "JSONObject/queryConfiguration", "JSONArray/queryEntries", "JSONObject/0", "JSONArray/clauses", "JSONObject/0", "JSONObject/query"});
        JSONObject termsJSONObject = queryJSONObject.getJSONObject("terms");
        long[] groupIds = JSONUtil.toLongArray((JSONArray)JSONUtil.getValueAsJSONArray((Object)termsJSONObject, (String[])new String[]{"JSONArray/scopeGroupId"}));
        queryJSONObject.put("terms", JSONUtil.put((String)"scopeGroupExternalReferenceCode", () -> {
            JSONArray jsonArray = this._jsonFactory.createJSONArray();
            for (long groupId : groupIds) {
                Group group = this._groupLocalService.getGroup(groupId);
                jsonArray.put(group.getExternalReferenceCode());
            }
            return jsonArray;
        }));
    }

    private void _upgradeElementDefinition(JSONObject sxpElementJSONObject) {
        JSONObject elementDefinitionJSONObject = sxpElementJSONObject.getJSONObject("elementDefinition");
        JSONUtil.getValueAsJSONObject((Object)elementDefinitionJSONObject, (String[])new String[]{"JSONObject/configuration", "JSONObject/queryConfiguration", "JSONArray/queryEntries", "JSONObject/0", "JSONArray/clauses", "JSONObject/0", "JSONObject/query"}).getJSONObject("terms").put("scopeGroupExternalReferenceCode", "${configuration.scope_group_external_reference_codes}").remove("scopeGroupId");
        JSONObject uiConfigurationJSONObject = elementDefinitionJSONObject.getJSONObject("uiConfiguration");
        JSONArray fieldsJSONArray = JSONUtil.getValueAsJSONArray((Object)uiConfigurationJSONObject, (String[])new String[]{"JSONArray/fieldSets", "JSONObject/0", "JSONArray/fields"});
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            fieldJSONObject.put("helpText", "scope-group-external-reference-codes-help").put("label", "scope-group-external-reference-codes").put("name", "scope_group_external_reference_codes").remove("helpTextLocalized");
            fieldJSONObject.remove("labelLocalized");
        }
    }

    private void _upgradeSXPBlueprint(PreparedStatement preparedStatement2, ResultSet resultSet) throws SQLException {
        block3: {
            String elementInstancesJSON = resultSet.getString("elementInstancesJSON");
            ElementInstance[] elementInstances = ElementInstanceUtil.toElementInstances((String)elementInstancesJSON);
            if (elementInstances == null || !this._hasLimitSearchToTheseSites(elementInstances)) {
                return;
            }
            try {
                preparedStatement2.setString(1, this._fixElementInstancesJSON(elementInstancesJSON));
                preparedStatement2.setLong(2, resultSet.getLong("sxpBlueprintId"));
                preparedStatement2.addBatch();
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block3;
                _log.info((Object)("Unable to upgrade search experiences blueprint " + resultSet.getLong("sxpBlueprintId")), (Throwable)exception);
            }
        }
    }

    private void _upgradeUIConfigurationValues(JSONObject elementInstanceJSONObject) throws Exception {
        JSONObject uiConfigurationValuesJSONObject = elementInstanceJSONObject.getJSONObject("uiConfigurationValues");
        JSONArray scopeGroupIdsJSONArray = uiConfigurationValuesJSONObject.getJSONArray("scope_group_ids");
        if (scopeGroupIdsJSONArray == null) {
            return;
        }
        JSONArray scopeGroupExternalReferenceCodesJSONArray = this._jsonFactory.createJSONArray();
        for (int i = 0; i < scopeGroupIdsJSONArray.length(); ++i) {
            JSONObject scopeGroupIdJSONObject = scopeGroupIdsJSONArray.getJSONObject(i);
            Group group = this._groupLocalService.getGroup(scopeGroupIdJSONObject.getLong("value"));
            scopeGroupExternalReferenceCodesJSONArray.put(JSONUtil.put((String)"label", (Object)StringBundler.concat((String[])new String[]{group.getDescriptiveName(), " (ERC: ", group.getExternalReferenceCode(), ")"})).put("value", group.getExternalReferenceCode()));
        }
        uiConfigurationValuesJSONObject.put("scope_group_external_reference_codes", scopeGroupExternalReferenceCodesJSONArray).remove("scope_group_ids");
    }
}

