/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.upgrade.v3_1_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SXPBlueprintAndSXPElementUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._upgradeSXPElement();
        this._upgradeSXPBlueprint();
    }

    private String _fixElementDefinition(String elementDefinition) throws Exception {
        if (Validator.isBlank((String)elementDefinition)) {
            return elementDefinition;
        }
        JSONObject sxpElementJSONObject = JSONFactoryUtil.createJSONObject((String)elementDefinition);
        if (sxpElementJSONObject == null) {
            return elementDefinition;
        }
        JSONObject uiConfigurationJSONObject = sxpElementJSONObject.getJSONObject("uiConfiguration");
        if (uiConfigurationJSONObject == null) {
            return elementDefinition;
        }
        JSONArray fieldSetsJSONArray = uiConfigurationJSONObject.getJSONArray("fieldSets");
        if (fieldSetsJSONArray == null) {
            return elementDefinition;
        }
        for (int i = 0; i < fieldSetsJSONArray.length(); ++i) {
            JSONObject fieldSetJSONObject = fieldSetsJSONArray.getJSONObject(i);
            JSONArray fieldsJSONArray = fieldSetJSONObject.getJSONArray("fields");
            if (fieldsJSONArray == null) continue;
            for (int j = 0; j < fieldsJSONArray.length(); ++j) {
                JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(j);
                JSONArray defaultValueJSONArray = fieldJSONObject.getJSONArray("defaultValue");
                JSONObject defaultValueJSONObject = fieldJSONObject.getJSONObject("defaultValue");
                if (defaultValueJSONArray != null) {
                    fieldJSONObject.remove("defaultValue");
                    fieldJSONObject.put("fieldMappings", defaultValueJSONArray);
                    continue;
                }
                if (defaultValueJSONObject == null) continue;
                fieldJSONObject.put("defaultValue", "");
            }
        }
        return sxpElementJSONObject.toString();
    }

    private String _fixElementInstancesJSON(String elementInstancesJSON) throws Exception {
        if (Validator.isBlank((String)elementInstancesJSON)) {
            return elementInstancesJSON;
        }
        JSONArray elementInstancesJSONArray = JSONFactoryUtil.createJSONArray((String)elementInstancesJSON);
        for (int i = 0; i < elementInstancesJSONArray.length(); ++i) {
            JSONObject elementDefinitionJSONObject;
            JSONObject sxpElementJSONObject;
            JSONObject elementInstanceJSONObject = elementInstancesJSONArray.getJSONObject(i);
            if (elementInstanceJSONObject == null || (sxpElementJSONObject = elementInstanceJSONObject.getJSONObject("sxpElement")) == null || (elementDefinitionJSONObject = sxpElementJSONObject.getJSONObject("elementDefinition")) == null) continue;
            sxpElementJSONObject.put("elementDefinition", JSONFactoryUtil.createJSONObject((String)this._fixElementDefinition(elementDefinitionJSONObject.toString())));
        }
        return elementInstancesJSONArray.toString();
    }

    private void _upgradeSXPBlueprint() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select sxpBlueprintId, elementInstancesJSON from SXPBlueprint");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPBlueprint set elementInstancesJSON = ? where sxpBlueprintId = ?");
             ResultSet resultSet1 = preparedStatement1.executeQuery();){
            while (resultSet1.next()) {
                preparedStatement2.setString(1, this._fixElementInstancesJSON(resultSet1.getString("elementInstancesJSON")));
                preparedStatement2.setLong(2, resultSet1.getLong("sxpBlueprintId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _upgradeSXPElement() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select elementDefinitionJSON, sxpElementId from SXPElement");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPElement set elementDefinitionJSON = ? where sxpElementId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                preparedStatement2.setString(1, this._fixElementDefinition(resultSet.getString("elementDefinitionJSON")));
                preparedStatement2.setLong(2, resultSet.getLong("sxpElementId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

