/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.upgrade.v3_1_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class SXPBlueprintAndSXPElementUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(SXPBlueprintAndSXPElementUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this._upgradeSXPElement();
        this._upgradeSXPBlueprint();
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"SXPElement", (String[])new String[]{"fallbackDescription STRING null", "fallbackTitle VARCHAR(500) null"})};
    }

    private String _addFieldsToElementInstancesJSON(String elementInstancesJSON) throws Exception {
        JSONArray elementInstancesJSONArray;
        block17: {
            if (elementInstancesJSON == null || elementInstancesJSON.isEmpty()) {
                return elementInstancesJSON;
            }
            elementInstancesJSONArray = JSONFactoryUtil.createJSONArray((String)elementInstancesJSON);
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select sxpElementId, title, description from SXPElement where sxpElementId = ?");){
                for (int i = 0; i < elementInstancesJSONArray.length(); ++i) {
                    JSONObject sxpElementJSONObject;
                    JSONObject elementInstanceJSONObject = elementInstancesJSONArray.getJSONObject(i);
                    if (elementInstanceJSONObject == null || (sxpElementJSONObject = elementInstanceJSONObject.getJSONObject("sxpElement")) == null) continue;
                    preparedStatement.setLong(1, sxpElementJSONObject.getLong("id"));
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        if (resultSet.next()) {
                            sxpElementJSONObject.put("fallbackDescription", this._getDefaultValue("Description", resultSet.getString("description"))).put("fallbackTitle", this._getDefaultValue("Title", resultSet.getString("title")));
                            continue;
                        }
                        sxpElementJSONObject.put("fallbackDescription", this._getFirstLocalizedValue(sxpElementJSONObject.getJSONObject("title_i18n"))).put("fallbackTitle", this._getFirstLocalizedValue(sxpElementJSONObject.getJSONObject("description_i18n")));
                        continue;
                    }
                }
            }
            catch (SQLException sqlException) {
                if (!_log.isWarnEnabled()) break block17;
                _log.warn((Throwable)sqlException);
            }
        }
        return elementInstancesJSONArray.toString();
    }

    private String _getDefaultValue(String fieldName, String xml) {
        int start;
        int end;
        if (!Validator.isBlank((String)xml) && (end = xml.indexOf("<", start = xml.indexOf(">", xml.indexOf("<" + fieldName)))) != -1 && start != -1) {
            return xml.substring(start + 1, end);
        }
        return "";
    }

    private Object _getFirstLocalizedValue(JSONObject i18nJSONObject) {
        Iterator iterator = i18nJSONObject.keys();
        if (!iterator.hasNext()) {
            return "";
        }
        return i18nJSONObject.get((String)iterator.next());
    }

    private void _upgradeSXPBlueprint() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select sxpBlueprintId, elementInstancesJSON from SXPBlueprint");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPBlueprint set elementInstancesJSON = ? where sxpBlueprintId = ?");
             ResultSet resultSet1 = preparedStatement1.executeQuery();){
            while (resultSet1.next()) {
                preparedStatement2.setString(1, this._addFieldsToElementInstancesJSON(resultSet1.getString("elementInstancesJSON")));
                preparedStatement2.setLong(2, resultSet1.getLong("sxpBlueprintId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _upgradeSXPElement() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select sxpElementId, title, description from SXPElement");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPElement set fallbackDescription = ?, fallbackTitle = ? where sxpElementId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                preparedStatement2.setString(1, this._getDefaultValue("description", resultSet.getString("description")));
                preparedStatement2.setString(2, this._getDefaultValue("title", resultSet.getString("title")));
                preparedStatement2.setLong(3, resultSet.getLong("sxpElementId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

