/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.upgrade.v3_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

public class SXPBlueprintUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._upgradeLowLevelSearchOptionsPortlets();
        this._upgradeSearchBarPortlets();
        this._upgradeSXPBlueprintOptionsPortlets();
    }

    private long _getSXPBlueprintIdByLargeValue(String largeValue) throws Exception {
        if (Validator.isNull((String)largeValue)) {
            return 0L;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)StringBundler.concat((String[])new String[]{"[", largeValue, "]"}));
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject attributesJSONObject;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject == null || (attributesJSONObject = jsonObject.getJSONObject("attributes")) == null || !attributesJSONObject.has("sxpBlueprintId")) continue;
            return attributesJSONObject.getLong("sxpBlueprintId");
        }
        return 0L;
    }

    private long _getSXPBlueprintIdBySmallValue(String smallValue) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)smallValue);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject == null || !Objects.equals(jsonObject.getString("key"), "search.experiences.blueprint.id")) continue;
            return jsonObject.getLong("value");
        }
        return 0L;
    }

    private String _updateSmallValueJSON(String externalReferenceCode, String smallValue) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)smallValue);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject == null || !Objects.equals(jsonObject.getString("key"), "search.experiences.blueprint.id")) continue;
            jsonObject.put("key", "search.experiences.blueprint.external.reference.code").put("value", externalReferenceCode);
        }
        return jsonArray.toString();
    }

    private void _upgradeLowLevelSearchOptionsPortlets() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select PortletPreferenceValue.smallValue, ", "PortletPreferenceValue.portletPreferencesId from ", "PortletPreferenceValue inner join PortletPreferences on ", "PortletPreferences.portletPreferencesId  = ", "PortletPreferenceValue.portletPreferencesId where ", "PortletPreferences.portletId like ", "'%com_liferay_portal_search_web_low_level_search_options_", "portlet_LowLevelSearchOptionsPortlet_INSTANCE%' and ", "PortletPreferenceValue.name = 'attributes'"}));
             ResultSet resultSet1 = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select externalReferenceCode from SXPBlueprint where sxpBlueprintId = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update PortletPreferenceValue set smallValue = ? where portletPreferencesId = ? and name = 'attributes'");){
            while (resultSet1.next()) {
                String smallValue = resultSet1.getString("smallValue");
                preparedStatement2.setLong(1, this._getSXPBlueprintIdBySmallValue(smallValue));
                ResultSet resultSet2 = preparedStatement2.executeQuery();
                if (!resultSet2.next()) continue;
                String newSmallValue = this._updateSmallValueJSON(resultSet2.getString("externalReferenceCode"), smallValue);
                preparedStatement3.setString(1, newSmallValue);
                preparedStatement3.setLong(2, resultSet1.getLong("portletPreferencesId"));
                preparedStatement3.addBatch();
            }
            preparedStatement3.executeBatch();
        }
    }

    private void _upgradeSearchBarPortlets() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select PortletPreferenceValue.largeValue, ", "PortletPreferenceValue.portletPreferencesId from ", "PortletPreferenceValue inner join PortletPreferences on ", "PortletPreferences.portletPreferencesId  = ", "PortletPreferenceValue.portletPreferencesId where ", "PortletPreferences.portletId like ", "'%com_liferay_portal_search_web_search_bar_portlet_", "SearchBarPortlet_INSTANCE_%' and ", "PortletPreferenceValue.name = ", "'suggestionsContributorConfigurations'"}));
             ResultSet resultSet1 = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select externalReferenceCode from SXPBlueprint where sxpBlueprintId = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update PortletPreferenceValue set largeValue = ? where portletPreferencesId = ? and name = 'suggestionsContributorConfigurations'");){
            while (resultSet1.next()) {
                String largeValue = resultSet1.getString("largeValue");
                preparedStatement2.setLong(1, this._getSXPBlueprintIdByLargeValue(largeValue));
                ResultSet resultSet2 = preparedStatement2.executeQuery();
                if (!resultSet2.next()) continue;
                String newLargeValue = StringUtil.replace((String)largeValue, (String)StringBundler.concat((Object[])new Object[]{StringUtil.quote((String)"sxpBlueprintId", (String)"\""), ":", this._getSXPBlueprintIdByLargeValue(largeValue)}), (String)StringBundler.concat((String[])new String[]{StringUtil.quote((String)"sxpBlueprintExternalReferenceCode", (String)"\""), ":", StringUtil.quote((String)resultSet2.getString("externalReferenceCode"), (String)"\"")}));
                preparedStatement3.setString(1, newLargeValue);
                preparedStatement3.setLong(2, resultSet1.getLong("portletPreferencesId"));
                preparedStatement3.addBatch();
            }
            preparedStatement3.executeBatch();
        }
    }

    private void _upgradeSXPBlueprintOptionsPortlets() {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select PortletPreferenceValue.smallValue, ", "PortletPreferenceValue.portletPreferencesId from ", "PortletPreferenceValue inner join PortletPreferences on ", "PortletPreferences.portletPreferencesId  = ", "PortletPreferenceValue.portletPreferencesId where ", "PortletPreferences.portletId like ", "'%com_liferay_search_experiences_web_internal_blueprint_", "options_portlet_SXPBlueprintOptionsPortlet_INSTANCE_%' ", "and PortletPreferenceValue.name = 'sxpBlueprintId'"}));
             ResultSet resultSet1 = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select externalReferenceCode from SXPBlueprint where sxpBlueprintId = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update PortletPreferenceValue set name = ?, smallValue = ? where portletPreferencesId = ? and name = 'sxpBlueprintId'");){
            while (resultSet1.next()) {
                preparedStatement2.setLong(1, resultSet1.getLong("smallValue"));
                ResultSet resultSet2 = preparedStatement2.executeQuery();
                if (!resultSet2.next()) continue;
                preparedStatement3.setString(1, "sxpBlueprintExternalReferenceCode");
                preparedStatement3.setString(2, resultSet2.getString("externalReferenceCode"));
                preparedStatement3.setLong(3, resultSet1.getLong("portletPreferencesId"));
                preparedStatement3.addBatch();
            }
            preparedStatement3.executeBatch();
        }
        catch (SQLException sqlException) {
            throw new RuntimeException(sqlException);
        }
    }
}

