/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.upgrade.v2_0_2;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.search.experiences.internal.model.listener.CompanyModelListener;
import com.liferay.search.experiences.rest.dto.v1_0.SXPElement;
import com.liferay.search.experiences.rest.dto.v1_0.util.SXPElementUtil;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SXPBlueprintAndSXPElementUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(SXPBlueprintAndSXPElementUpgradeProcess.class);
    private Map<String, SXPElement> _sxpElements;

    protected void doUpgrade() throws Exception {
        this._upgradeSXPBlueprints();
        this._upgradeSXPElements();
    }

    private Map<String, SXPElement> _getSXPElements() {
        if (this._sxpElements != null) {
            return this._sxpElements;
        }
        Bundle bundle = FrameworkUtil.getBundle(CompanyModelListener.class);
        Package pkg = CompanyModelListener.class.getPackage();
        String path = StringUtil.replace((String)pkg.getName(), (char)'.', (char)'/');
        this._sxpElements = new HashMap<String, SXPElement>();
        Enumeration enumeration = bundle.findEntries(path.concat("/dependencies"), "*.json", false);
        try {
            while (enumeration.hasMoreElements()) {
                SXPElement sxpElement = SXPElementUtil.toSXPElement((String)URLUtil.toString((URL)((URL)enumeration.nextElement())));
                this._sxpElements.put(sxpElement.getExternalReferenceCode(), sxpElement);
            }
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
        return this._sxpElements;
    }

    private String _upgradeElementInstancesJSON(String elementInstancesJSON) throws Exception {
        if (elementInstancesJSON.equals("[]") || elementInstancesJSON.equals("{}")) {
            return "[]";
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)elementInstancesJSON);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject1 = jsonArray.getJSONObject(i);
            JSONObject sxpElementJSONObject = jsonObject1.getJSONObject("sxpElement");
            Map<String, SXPElement> sxpElements = this._getSXPElements();
            SXPElement sxpElement = sxpElements.get(sxpElementJSONObject.getString("externalReferenceCode"));
            if (sxpElement == null) continue;
            Map descriptionMap = sxpElement.getDescription_i18n();
            sxpElementJSONObject.put("description", (String)descriptionMap.get(LocaleUtil.toLanguageId((Locale)LocaleUtil.US))).put("description_i18n", JSONFactoryUtil.createJSONObject((Map)descriptionMap));
            Map titleMap = sxpElement.getTitle_i18n();
            sxpElementJSONObject.put("title", (String)titleMap.get(LocaleUtil.toLanguageId((Locale)LocaleUtil.US))).put("title_i18n", JSONFactoryUtil.createJSONObject((Map)titleMap));
        }
        return jsonArray.toString();
    }

    private void _upgradeSXPBlueprints() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select sxpBlueprintId, elementInstancesJSON from SXPBlueprint");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPBlueprint set elementInstancesJSON = ? where sxpBlueprintId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                try {
                    preparedStatement2.setString(1, this._upgradeElementInstancesJSON(resultSet.getString("elementInstancesJSON")));
                    preparedStatement2.setLong(2, resultSet.getLong("sxpBlueprintId"));
                    preparedStatement2.addBatch();
                }
                catch (RuntimeException runtimeException) {
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Search experiences blueprint ", resultSet.getLong("sxpBlueprintId"), " contains corrupted element instances JSON"}), (Throwable)runtimeException);
                }
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _upgradeSXPElements() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select externalReferenceCode, readOnly from SXPElement");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPElement set description = ?, elementDefinitionJSON = ?, title = ? where externalReferenceCode = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                Map<String, SXPElement> sxpElements;
                SXPElement sxpElement;
                if (!resultSet.getBoolean("readOnly") || (sxpElement = (sxpElements = this._getSXPElements()).get(resultSet.getString("externalReferenceCode"))) == null) continue;
                preparedStatement2.setString(1, LocalizationUtil.getXml((Map)sxpElement.getDescription_i18n(), (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.US), (String)"description"));
                preparedStatement2.setString(2, String.valueOf(sxpElement.getElementDefinition()));
                preparedStatement2.setString(3, LocalizationUtil.getXml((Map)sxpElement.getTitle_i18n(), (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.US), (String)"title"));
                preparedStatement2.setString(4, resultSet.getString("externalReferenceCode"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

