/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.upgrade.v2_0_1;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.search.experiences.rest.dto.v1_0.util.ElementInstanceUtil;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SXPBlueprintUpgradeProcess
extends UpgradeProcess {
    private static final String[] _EXTERNAL_REFERENCE_CODES = new String[]{"BOOST_ALL_KEYWORDS_MATCH", "BOOST_PROXIMITY", "SEARCH_WITH_QUERY_STRING_SYNTAX", "TEXT_MATCH_OVER_MULTIPLE_FIELDS"};
    private static final Log _log = LogFactoryUtil.getLog(SXPBlueprintUpgradeProcess.class);
    private static final Pattern _pattern = Pattern.compile("Ljava\\.lang\\.Object;@\\w{8}");
    private final Map<String, String> _defaultValues = this._initDefaultValues();

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select sxpBlueprintId, elementInstancesJSON from SXPBlueprint");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPBlueprint set elementInstancesJSON = ? where sxpBlueprintId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String elementInstancesJSON = resultSet.getString("elementInstancesJSON");
                try {
                    ElementInstanceUtil.toElementInstances((String)elementInstancesJSON);
                }
                catch (RuntimeException runtimeException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Search experiences blueprint with ID ", resultSet.getLong("sxpBlueprintId"), " contains corrupted element instances ", "JSON"}), (Throwable)runtimeException);
                    }
                    preparedStatement2.setString(1, this._fixElementInstancesJSON(elementInstancesJSON));
                    preparedStatement2.setLong(2, resultSet.getLong("sxpBlueprintId"));
                    preparedStatement2.addBatch();
                }
            }
            preparedStatement2.executeBatch();
        }
    }

    private String _fixElementInstancesJSON(String elementInstancesJSON) throws Exception {
        Matcher matcher = _pattern.matcher(elementInstancesJSON);
        if (!matcher.find()) {
            return elementInstancesJSON;
        }
        elementInstancesJSON = matcher.replaceAll("]");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)elementInstancesJSON);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONObject sxpElementJSONObject = jsonObject.getJSONObject("sxpElement");
            String externalReferenceCode = sxpElementJSONObject.getString("externalReferenceCode");
            if (!ArrayUtil.contains((Object[])_EXTERNAL_REFERENCE_CODES, (Object)externalReferenceCode)) continue;
            String elementDefinitionJSON = sxpElementJSONObject.getString("elementDefinition");
            elementDefinitionJSON = StringUtil.replace((String)elementDefinitionJSON, (String)"\"defaultValue\":[]", (String)this._defaultValues.get(externalReferenceCode));
            sxpElementJSONObject.put("elementDefinition", JSONFactoryUtil.createJSONObject((String)elementDefinitionJSON));
        }
        return jsonArray.toString();
    }

    private Map<String, String> _initDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        Bundle bundle = FrameworkUtil.getBundle(SXPBlueprintUpgradeProcess.class);
        Package pkg = SXPBlueprintUpgradeProcess.class.getPackage();
        String path = StringUtil.replace((String)pkg.getName(), (char)'.', (char)'/') + "/dependencies/";
        for (String externalReferenceCode : _EXTERNAL_REFERENCE_CODES) {
            URL url = bundle.getEntry(path + StringUtil.toLowerCase((String)externalReferenceCode) + ".txt");
            try {
                defaultValues.put(externalReferenceCode, URLUtil.toString((URL)url));
            }
            catch (IOException ioException) {
                _log.error((Object)("Unable to get default value for element with external reference code: " + externalReferenceCode), (Throwable)ioException);
            }
        }
        return defaultValues;
    }
}

