/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.upgrade.v1_3_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.search.experiences.model.impl.SXPElementImpl;
import com.liferay.search.experiences.rest.dto.v1_0.ElementDefinition;
import com.liferay.search.experiences.rest.dto.v1_0.SXPElement;
import com.liferay.search.experiences.rest.dto.v1_0.util.ElementInstanceUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class SXPBlueprintAndSXPElementUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(SXPBlueprintAndSXPElementUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this._upgradeSXPElement();
        this._upgradeSXPBlueprint();
    }

    private com.liferay.search.experiences.model.SXPElement _fetchSXPElement(long sxpElementId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select sxpElementId, externalReferenceCode, readOnly, version from SXPElement where sxpElementId = " + sxpElementId);
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                SXPElementImpl sxpElement = new SXPElementImpl();
                sxpElement.setExternalReferenceCode(resultSet.getString("externalReferenceCode"));
                sxpElement.setSXPElementId(resultSet.getLong("sxpElementId"));
                sxpElement.setReadOnly(resultSet.getBoolean("readOnly"));
                sxpElement.setVersion(resultSet.getString("version"));
                SXPElementImpl sXPElementImpl = sxpElement;
                return sXPElementImpl;
            }
        }
        return null;
    }

    private String _getElementInstancesJSON(String elementInstancesJSON) throws Exception {
        Object[] elementInstances = ElementInstanceUtil.toElementInstances((String)elementInstancesJSON);
        if (ArrayUtil.isEmpty((Object[])elementInstances)) {
            return "[]";
        }
        for (Object elementInstance : elementInstances) {
            SXPElement sxpElement = elementInstance.getSxpElement();
            if (sxpElement.getId() == null) continue;
            com.liferay.search.experiences.model.SXPElement serviceBuilderSXPElement = this._fetchSXPElement(sxpElement.getId());
            if (serviceBuilderSXPElement == null) {
                _log.error((Object)("No search experiences element exists with ID " + sxpElement.getId()));
                continue;
            }
            if (serviceBuilderSXPElement.isReadOnly()) {
                if (Objects.equals(serviceBuilderSXPElement.getExternalReferenceCode(), "BOOST_CONTENTS_IN_A_CATEGORY_FOR_A_PERIOD_OF_TIME") || Objects.equals(serviceBuilderSXPElement.getExternalReferenceCode(), "BOOST_CONTENTS_IN_A_CATEGORY_FOR_THE_TIME_OF_DAY") || Objects.equals(serviceBuilderSXPElement.getExternalReferenceCode(), "LIMIT_SEARCH_TO_CONTENTS_CREATED_WITHIN_A_PERIOD_OF_TIME")) {
                    ElementDefinition elementDefinition = sxpElement.getElementDefinition();
                    sxpElement.setElementDefinition(() -> ElementDefinition.unsafeToDTO((String)this._renameElementDefinitionJSON(String.valueOf(elementDefinition))));
                }
                Map description_i18n = sxpElement.getDescription_i18n();
                description_i18n.put("en-US", this._renameDescription((String)description_i18n.get("en-US")));
                Map title_i18n = sxpElement.getTitle_i18n();
                title_i18n.put("en-US", this._renameTitle((String)title_i18n.get("en-US")));
            }
            sxpElement.setExternalReferenceCode(() -> ((com.liferay.search.experiences.model.SXPElement)serviceBuilderSXPElement).getExternalReferenceCode());
            sxpElement.setVersion(() -> ((com.liferay.search.experiences.model.SXPElement)serviceBuilderSXPElement).getVersion());
        }
        return Arrays.toString(elementInstances);
    }

    private String _getExternalReferenceCode(String title) throws Exception {
        String localizedTitle = LocalizationUtil.getLocalization((String)title, (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.US));
        return StringUtil.replace((String)StringUtil.toUpperCase((String)localizedTitle), (char)' ', (char)'_');
    }

    private String _renameDescription(String description) {
        return StringUtil.replace((String)description, (String)"Boost contents in a category for users belonging to a given user segment", (String)"Boost contents in a category for users belonging to the given user segments");
    }

    private String _renameElementDefinitionJSON(String elementDefinitionJSON) {
        return StringUtil.replace((String)elementDefinitionJSON, (String[])new String[]{"Create Date: From", "Create Date: To", "Morning (4am - 12am)"}, (String[])new String[]{"Date: From", "Date: To", "Morning (4am - 12pm)"});
    }

    private String _renameTitle(String title) {
        return StringUtil.replace((String)title, (String[])new String[]{"Boost Contents in a Category for a User Segment", "Search with the Lucene Syntax"}, (String[])new String[]{"Boost Contents in a Category for User Segments", "Search with Query String Syntax"});
    }

    private void _upgradeSXPBlueprint() throws Exception {
        this.alterTableDropColumn("SXPBlueprint", "key_");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select sxpBlueprintId, elementInstancesJSON, version from SXPBlueprint");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPBlueprint set elementInstancesJSON = ?, version = ? where sxpBlueprintId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                preparedStatement2.setString(1, this._getElementInstancesJSON(resultSet.getString("elementInstancesJSON")));
                String version = resultSet.getString("version");
                if (Validator.isNull((String)version)) {
                    version = "1.0";
                }
                preparedStatement2.setString(2, version);
                preparedStatement2.setLong(3, resultSet.getLong("sxpBlueprintId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _upgradeSXPElement() throws Exception {
        this.alterTableDropColumn("SXPElement", "key_");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select externalReferenceCode, sxpElementId, description, elementDefinitionJSON, readOnly, title, version from SXPElement");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"update SXPElement set externalReferenceCode = ?, ", "description = ?, elementDefinitionJSON = ?, title = ", "?, version = ? where sxpElementId = ?"}));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String externalReferenceCode = resultSet.getString("externalReferenceCode");
                String description = resultSet.getString("description");
                String elementDefinitionJSON = resultSet.getString("elementDefinitionJSON");
                String title = resultSet.getString("title");
                if (resultSet.getBoolean("readOnly")) {
                    title = this._renameTitle(title);
                    externalReferenceCode = this._getExternalReferenceCode(title);
                    description = this._renameDescription(description);
                    elementDefinitionJSON = this._renameElementDefinitionJSON(elementDefinitionJSON);
                }
                preparedStatement2.setString(1, externalReferenceCode);
                preparedStatement2.setString(2, description);
                preparedStatement2.setString(3, elementDefinitionJSON);
                preparedStatement2.setString(4, title);
                String version = resultSet.getString("version");
                if (Validator.isNull((String)version)) {
                    version = "1.0";
                }
                preparedStatement2.setString(5, version);
                preparedStatement2.setLong(6, resultSet.getLong("sxpElementId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

