/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.security.permission.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.search.experiences.model.SXPElement;
import com.liferay.search.experiences.service.SXPElementLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.search.experiences.model.SXPElement"}, service={ModelResourcePermission.class})
public class SXPElementModelResourcePermission
implements ModelResourcePermission<SXPElement> {
    @Reference(target="(resource.name=com.liferay.search.experiences)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private SXPElementLocalService _sxpBlueprintLocalService;

    public void check(PermissionChecker permissionChecker, long sxpBlueprintId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, sxpBlueprintId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, SXPElement.class.getName(), sxpBlueprintId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, SXPElement sxpBlueprint, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, sxpBlueprint, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, SXPElement.class.getName(), sxpBlueprint.getPrimaryKey(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long sxpBlueprintId, String actionId) throws PortalException {
        SXPElement sxpBlueprint = this._sxpBlueprintLocalService.getSXPElement(sxpBlueprintId);
        return this.contains(permissionChecker, sxpBlueprint, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, SXPElement sxpBlueprint, String actionId) throws PortalException {
        return permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), SXPElement.class.getName(), sxpBlueprint.getSXPElementId(), sxpBlueprint.getUserId(), actionId) || permissionChecker.getUserId() == sxpBlueprint.getUserId() || permissionChecker.hasPermission(null, SXPElement.class.getName(), sxpBlueprint.getPrimaryKey(), actionId);
    }

    public String getModelName() {
        return SXPElement.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

