/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.security.permission.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.search.experiences.model.SXPBlueprint;
import com.liferay.search.experiences.service.SXPBlueprintLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.search.experiences.model.SXPBlueprint"}, service={ModelResourcePermission.class})
public class SXPBlueprintModelResourcePermission
implements ModelResourcePermission<SXPBlueprint> {
    @Reference(target="(resource.name=com.liferay.search.experiences)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private SXPBlueprintLocalService _sxpBlueprintLocalService;

    public void check(PermissionChecker permissionChecker, long sxpBlueprintId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, sxpBlueprintId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, SXPBlueprint.class.getName(), sxpBlueprintId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, SXPBlueprint sxpBlueprint, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, sxpBlueprint, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, SXPBlueprint.class.getName(), sxpBlueprint.getPrimaryKey(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long sxpBlueprintId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._sxpBlueprintLocalService.getSXPBlueprint(sxpBlueprintId), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, SXPBlueprint sxpBlueprint, String actionId) throws PortalException {
        return permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), SXPBlueprint.class.getName(), sxpBlueprint.getSXPBlueprintId(), sxpBlueprint.getUserId(), actionId) || permissionChecker.getUserId() == sxpBlueprint.getUserId() || permissionChecker.hasPermission(null, SXPBlueprint.class.getName(), sxpBlueprint.getPrimaryKey(), actionId);
    }

    public String getModelName() {
        return SXPBlueprint.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

