/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.search.experiences.model.SXPBlueprint;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"indexer.class.name=com.liferay.search.experiences.model.SXPBlueprint"}, service={ModelDocumentContributor.class})
public class SXPBlueprintModelDocumentContributor
implements ModelDocumentContributor<SXPBlueprint> {
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;

    public void contribute(Document document, SXPBlueprint sxpBlueprint) {
        document.addDate("modified", sxpBlueprint.getModifiedDate());
        document.addKeyword("status", sxpBlueprint.getStatus());
        for (Locale locale : this._language.getCompanyAvailableLocales(sxpBlueprint.getCompanyId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addKeyword(Field.getSortableFieldName((String)this._localization.getLocalizedName("description", languageId)), sxpBlueprint.getDescription(locale), true);
            document.addKeyword(Field.getSortableFieldName((String)this._localization.getLocalizedName("title", languageId)), sxpBlueprint.getTitle(locale), true);
            document.addText(this._localization.getLocalizedName("description", languageId), sxpBlueprint.getDescription(locale));
            document.addText(this._localization.getLocalizedName("title", languageId), sxpBlueprint.getTitle(locale));
        }
    }
}

