/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.model.listener;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.search.tuning.rankings.index.Ranking;
import com.liferay.portal.search.tuning.rankings.index.RankingBuilderFactory;
import com.liferay.portal.search.tuning.rankings.index.RankingIndexReader;
import com.liferay.portal.search.tuning.rankings.index.name.RankingIndexName;
import com.liferay.portal.search.tuning.rankings.index.name.RankingIndexNameBuilder;
import com.liferay.portal.search.tuning.rankings.storage.RankingStorageAdapter;
import com.liferay.search.experiences.model.SXPBlueprint;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={ModelListener.class})
public class SXPBlueprintModelListener
extends BaseModelListener<SXPBlueprint> {
    @Reference
    private RankingBuilderFactory _rankingBuilderFactory;
    @Reference
    private RankingIndexNameBuilder _rankingIndexNameBuilder;
    @Reference
    private RankingIndexReader _rankingIndexReader;
    @Reference
    private RankingStorageAdapter _rankingStorageAdapter;

    public void onBeforeRemove(SXPBlueprint sxpBlueprint) {
        try {
            RankingIndexName rankingIndexName = this._rankingIndexNameBuilder.getRankingIndexName(sxpBlueprint.getCompanyId());
            List rankings = this._rankingIndexReader.fetchBySXPBlueprintExternalReferenceCode(rankingIndexName, sxpBlueprint.getExternalReferenceCode());
            if (rankings == null) {
                return;
            }
            for (Ranking ranking : rankings) {
                Ranking.Builder rankingBuilder = this._rankingBuilderFactory.builder(ranking);
                rankingBuilder.status("not-applicable");
                this._rankingStorageAdapter.update(rankingBuilder.build(), rankingIndexName);
            }
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }
}

