/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.model.listener;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.search.experiences.internal.util.SXPElementUtil;
import com.liferay.search.experiences.service.SXPBlueprintLocalService;
import com.liferay.search.experiences.service.SXPElementLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    private static final Log _log = LogFactoryUtil.getLog(CompanyModelListener.class);
    @Reference
    private SXPBlueprintLocalService _sxpBlueprintLocalService;
    @Reference
    private SXPElementLocalService _sxpElementLocalService;

    public void onAfterCreate(Company company) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            try {
                SXPElementUtil.addSXPElements(company, this._sxpElementLocalService);
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
            return null;
        });
    }

    public void onAfterRemove(Company company) {
        try {
            this._sxpBlueprintLocalService.deleteCompanySXPBlueprints(company.getCompanyId());
            this._sxpElementLocalService.deleteCompanySXPElements(company.getCompanyId());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }
}

