/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.info.collection.provider;

import com.liferay.asset.util.AssetHelper;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.FilteredInfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.filter.CategoriesInfoFilter;
import com.liferay.info.filter.InfoFilter;
import com.liferay.info.filter.KeywordsInfoFilter;
import com.liferay.info.filter.TagsInfoFilter;
import com.liferay.info.pagination.Pagination;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.search.experiences.model.SXPBlueprint;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public abstract class SXPBlueprintInfoCollectionProvider<T>
implements FilteredInfoCollectionProvider<T>,
SingleFormVariationInfoCollectionProvider<T> {
    protected final AssetHelper assetHelper;
    protected final Searcher searcher;
    protected final SearchRequestBuilderFactory searchRequestBuilderFactory;
    protected final SXPBlueprint sxpBlueprint;

    public SXPBlueprintInfoCollectionProvider(AssetHelper assetHelper, Searcher searcher, SearchRequestBuilderFactory searchRequestBuilderFactory, SXPBlueprint sxpBlueprint) {
        this.assetHelper = assetHelper;
        this.searcher = searcher;
        this.searchRequestBuilderFactory = searchRequestBuilderFactory;
        this.sxpBlueprint = sxpBlueprint;
    }

    public SearchResponse getCollectionQuerySearchResponse(CollectionQuery collectionQuery) {
        Pagination pagination = collectionQuery.getPagination();
        SearchRequestBuilder searchRequestBuilder = this.getSearchRequestBuilder(collectionQuery, pagination);
        return this.searcher.search(searchRequestBuilder.build());
    }

    public String getFormVariationKey() {
        return this.sxpBlueprint.getExternalReferenceCode();
    }

    public String getKey() {
        return StringBundler.concat((Object[])new Object[]{SXPBlueprint.class.getName(), "_", this.sxpBlueprint.getCompanyId(), "_", this.sxpBlueprint.getExternalReferenceCode()});
    }

    public String getLabel(Locale locale) {
        return this.sxpBlueprint.getTitle(locale);
    }

    public List<InfoFilter> getSupportedInfoFilters() {
        return Arrays.asList(new CategoriesInfoFilter(), new KeywordsInfoFilter(), new TagsInfoFilter());
    }

    public boolean isAvailable() {
        return FeatureFlagManagerUtil.isEnabled((String)"LPS-129412") && this.sxpBlueprint.getCompanyId() == CompanyThreadLocal.getCompanyId().longValue();
    }

    protected SearchRequestBuilder getSearchRequestBuilder(CollectionQuery collectionQuery, Pagination pagination) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        return this.searchRequestBuilderFactory.builder().companyId(Long.valueOf(serviceContext.getCompanyId())).fetchSource(false).fields(new String[0]).from(Integer.valueOf(pagination.getStart())).emptySearchEnabled(true).size(Integer.valueOf(pagination.getEnd() - pagination.getStart())).withSearchContext(searchContext -> {
            TagsInfoFilter tagsInfoFilter;
            CategoriesInfoFilter categoriesInfoFilter = (CategoriesInfoFilter)collectionQuery.getInfoFilter(CategoriesInfoFilter.class);
            if (categoriesInfoFilter != null && ArrayUtil.isNotEmpty((Object[])categoriesInfoFilter.getCategoryIds())) {
                long[] categoryIds = ArrayUtil.append((long[][])categoriesInfoFilter.getCategoryIds());
                categoryIds = ArrayUtil.unique((long[])categoryIds);
                searchContext.setAssetCategoryIds(categoryIds);
            }
            if ((tagsInfoFilter = (TagsInfoFilter)collectionQuery.getInfoFilter(TagsInfoFilter.class)) != null && ArrayUtil.isNotEmpty((Object[])tagsInfoFilter.getTagNames())) {
                String[] tagNames = (String[])ArrayUtil.append((Object[][])tagsInfoFilter.getTagNames());
                tagNames = ArrayUtil.unique((String[])tagNames);
                searchContext.setAssetTagNames(tagNames);
            }
            searchContext.setAttribute("search.experiences.blueprint.external.reference.code", (Serializable)((Object)this.sxpBlueprint.getExternalReferenceCode()));
            searchContext.setAttribute("search.experiences.ip.address", (Serializable)((Object)serviceContext.getRemoteAddr()));
            ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
            searchContext.setAttribute("search.experiences.scope.group.id", (Serializable)Long.valueOf(themeDisplay.getScopeGroupId()));
            KeywordsInfoFilter keywordsInfoFilter = (KeywordsInfoFilter)collectionQuery.getInfoFilter(KeywordsInfoFilter.class);
            if (keywordsInfoFilter != null) {
                String keywords = keywordsInfoFilter.getKeywords();
                searchContext.setKeywords(keywords);
                if (!Validator.isBlank((String)keywords)) {
                    searchContext.setAttribute("search.contribute.tuning.rankings", (Serializable)Boolean.TRUE);
                }
            }
            searchContext.setLocale(serviceContext.getLocale());
            searchContext.setTimeZone(serviceContext.getTimeZone());
            searchContext.setUserId(serviceContext.getUserId());
        });
    }
}

