/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.info.collection.provider;

import com.liferay.asset.util.AssetHelper;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.FilteredInfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.search.experiences.internal.info.collection.provider.SXPBlueprintInfoCollectionProvider;
import com.liferay.search.experiences.model.SXPBlueprint;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ObjectEntrySXPBlueprintInfoCollectionProvider
extends SXPBlueprintInfoCollectionProvider<ObjectEntry>
implements FilteredInfoCollectionProvider<ObjectEntry>,
SingleFormVariationInfoCollectionProvider<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntrySXPBlueprintInfoCollectionProvider.class);
    private final ObjectDefinition _objectDefinition;
    private final ObjectEntryLocalService _objectEntryLocalService;

    public ObjectEntrySXPBlueprintInfoCollectionProvider(AssetHelper assetHelper, String className, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, Searcher searcher, SearchRequestBuilderFactory searchRequestBuilderFactory, SXPBlueprint sxpBlueprint) {
        super(assetHelper, searcher, searchRequestBuilderFactory, sxpBlueprint);
        this._objectDefinition = objectDefinitionLocalService.fetchObjectDefinitionByClassName(sxpBlueprint.getCompanyId(), className);
        this._objectEntryLocalService = objectEntryLocalService;
    }

    public InfoPage<ObjectEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        try {
            SearchResponse searchResponse = this.getCollectionQuerySearchResponse(collectionQuery);
            return InfoPage.of(this._getObjectEntries(searchResponse.getSearchHits()), (Pagination)collectionQuery.getPagination(), (int)searchResponse.getTotalHits());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get object entry", (Throwable)exception);
            }
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    public String getCollectionItemClassName() {
        return this._objectDefinition.getClassName();
    }

    @Override
    public boolean isAvailable() {
        if (this._objectDefinition.getCompanyId() != CompanyThreadLocal.getCompanyId().longValue()) {
            return false;
        }
        return super.isAvailable();
    }

    private List<ObjectEntry> _getObjectEntries(SearchHits searchHits) {
        return TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            return this._objectEntryLocalService.fetchObjectEntry(document.getLong("entryClassPK").longValue());
        });
    }
}

