/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.info.collection.provider;

import com.liferay.asset.util.AssetHelper;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.FilteredInfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.search.experiences.internal.info.collection.provider.SXPBlueprintInfoCollectionProvider;
import com.liferay.search.experiences.model.SXPBlueprint;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class KBArticleSXPBlueprintInfoCollectionProvider
extends SXPBlueprintInfoCollectionProvider<KBArticle>
implements FilteredInfoCollectionProvider<KBArticle>,
SingleFormVariationInfoCollectionProvider<KBArticle> {
    private static final Log _log = LogFactoryUtil.getLog(KBArticleSXPBlueprintInfoCollectionProvider.class);
    private final KBArticleLocalService _kbArticleLocalService;

    public KBArticleSXPBlueprintInfoCollectionProvider(AssetHelper assetHelper, KBArticleLocalService kbArticleLocalService, Searcher searcher, SearchRequestBuilderFactory searchRequestBuilderFactory, SXPBlueprint sxpBlueprint) {
        super(assetHelper, searcher, searchRequestBuilderFactory, sxpBlueprint);
        this._kbArticleLocalService = kbArticleLocalService;
    }

    public InfoPage<KBArticle> getCollectionInfoPage(CollectionQuery collectionQuery) {
        try {
            SearchResponse searchResponse = this.getCollectionQuerySearchResponse(collectionQuery);
            return InfoPage.of(this._getKBArticles(searchResponse.getSearchHits()), (Pagination)collectionQuery.getPagination(), (int)searchResponse.getTotalHits());
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get knowledge base articles", (Throwable)exception);
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    private List<KBArticle> _getKBArticles(SearchHits searchHits) {
        return TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            return this._kbArticleLocalService.getLatestKBArticle(document.getLong("entryClassPK").longValue());
        });
    }
}

