/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.info.collection.provider;

import com.liferay.asset.util.AssetHelper;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.FilteredInfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.asset.AssetSubtypeIdentifier;
import com.liferay.portal.search.asset.AssetSubtypeIdentifierBuilder;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.search.experiences.internal.info.collection.provider.SXPBlueprintInfoCollectionProvider;
import com.liferay.search.experiences.model.SXPBlueprint;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import com.liferay.search.experiences.rest.dto.v1_0.GeneralConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class JournalArticleSXPBlueprintInfoCollectionProvider
extends SXPBlueprintInfoCollectionProvider<JournalArticle>
implements FilteredInfoCollectionProvider<JournalArticle>,
SingleFormVariationInfoCollectionProvider<JournalArticle> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleSXPBlueprintInfoCollectionProvider.class);
    private final AssetSubtypeIdentifierBuilder _assetSubtypeIdentifierBuilder;
    private final ClassNameLocalService _classNameLocalService;
    private final DDMStructureService _ddmStructureService;
    private final GroupService _groupService;
    private final JournalArticleService _journalArticleService;

    public JournalArticleSXPBlueprintInfoCollectionProvider(AssetHelper assetHelper, AssetSubtypeIdentifierBuilder assetSubtypeIdentifierBuilder, ClassNameLocalService classNameLocalService, DDMStructureService ddmStructureService, GroupService groupService, JournalArticleService journalArticleService, Searcher searcher, SearchRequestBuilderFactory searchRequestBuilderFactory, SXPBlueprint sxpBlueprint) {
        super(assetHelper, searcher, searchRequestBuilderFactory, sxpBlueprint);
        this._assetSubtypeIdentifierBuilder = assetSubtypeIdentifierBuilder;
        this._classNameLocalService = classNameLocalService;
        this._ddmStructureService = ddmStructureService;
        this._groupService = groupService;
        this._journalArticleService = journalArticleService;
    }

    public InfoPage<JournalArticle> getCollectionInfoPage(CollectionQuery collectionQuery) {
        try {
            SearchResponse searchResponse = this.getCollectionQuerySearchResponse(collectionQuery);
            return InfoPage.of(this._getJournalArticles(searchResponse.getSearchHits()), (Pagination)collectionQuery.getPagination(), (int)searchResponse.getTotalHits());
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get journal articles", (Throwable)exception);
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    @Override
    public String getFormVariationKey() {
        Group group;
        Configuration configuration = Configuration.unsafeToDTO((String)this.sxpBlueprint.getConfigurationJSON());
        GeneralConfiguration generalConfiguration = configuration.getGeneralConfiguration();
        AssetSubtypeIdentifier assetSubtypeIdentifier = this._assetSubtypeIdentifierBuilder.searchableAssetType(generalConfiguration.getCollectionProviderType()).build();
        if (Validator.isBlank((String)assetSubtypeIdentifier.getSubtypeExternalReferenceCode())) {
            return "0";
        }
        try {
            group = this._groupService.fetchGroupByExternalReferenceCode(assetSubtypeIdentifier.getGroupExternalReferenceCode(), this.sxpBlueprint.getCompanyId());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get group with external reference code " + assetSubtypeIdentifier.getGroupExternalReferenceCode()), (Throwable)exception);
            }
            return "0";
        }
        String subtypeExternalReferenceCode = assetSubtypeIdentifier.getSubtypeExternalReferenceCode();
        try {
            DDMStructure ddmStructure = this._ddmStructureService.fetchStructureByExternalReferenceCode(subtypeExternalReferenceCode, group.getGroupId(), this._classNameLocalService.getClassNameId(JournalArticle.class));
            return String.valueOf(ddmStructure.getStructureId());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get dynamic data mapping structure with external reference code " + subtypeExternalReferenceCode), (Throwable)exception);
            }
            return "0";
        }
    }

    private List<JournalArticle> _getJournalArticles(SearchHits searchHits) {
        return TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            return this._journalArticleService.getLatestArticle(document.getLong("entryClassPK").longValue());
        });
    }
}

