/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.info.collection.provider;

import com.liferay.asset.util.AssetHelper;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.FilteredInfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.asset.AssetSubtypeIdentifier;
import com.liferay.portal.search.asset.AssetSubtypeIdentifierBuilder;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.search.experiences.internal.info.collection.provider.SXPBlueprintInfoCollectionProvider;
import com.liferay.search.experiences.model.SXPBlueprint;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import com.liferay.search.experiences.rest.dto.v1_0.GeneralConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileEntrySXPBlueprintInfoCollectionProvider
extends SXPBlueprintInfoCollectionProvider<FileEntry>
implements FilteredInfoCollectionProvider<FileEntry>,
SingleFormVariationInfoCollectionProvider<FileEntry> {
    private static final Log _log = LogFactoryUtil.getLog(FileEntrySXPBlueprintInfoCollectionProvider.class);
    private final AssetSubtypeIdentifierBuilder _assetSubtypeIdentifierBuilder;
    private final DLAppLocalService _dlAppLocalService;
    private final DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    private final GroupService _groupService;

    public FileEntrySXPBlueprintInfoCollectionProvider(AssetHelper assetHelper, AssetSubtypeIdentifierBuilder assetSubtypeIdentifierBuilder, DLAppLocalService dlAppLocalService, DLFileEntryTypeLocalService dlFileEntryTypeLocalService, GroupService groupService, Searcher searcher, SearchRequestBuilderFactory searchRequestBuilderFactory, SXPBlueprint sxpBlueprint) {
        super(assetHelper, searcher, searchRequestBuilderFactory, sxpBlueprint);
        this._assetSubtypeIdentifierBuilder = assetSubtypeIdentifierBuilder;
        this._dlAppLocalService = dlAppLocalService;
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
        this._groupService = groupService;
    }

    public InfoPage<FileEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        try {
            SearchResponse searchResponse = this.getCollectionQuerySearchResponse(collectionQuery);
            return InfoPage.of(this._getDLFileEntries(searchResponse.getSearchHits()), (Pagination)collectionQuery.getPagination(), (int)searchResponse.getTotalHits());
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get document library file entry", (Throwable)exception);
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    @Override
    public String getFormVariationKey() {
        Group group;
        Configuration configuration = Configuration.unsafeToDTO((String)this.sxpBlueprint.getConfigurationJSON());
        GeneralConfiguration generalConfiguration = configuration.getGeneralConfiguration();
        AssetSubtypeIdentifier assetSubtypeIdentifier = this._assetSubtypeIdentifierBuilder.searchableAssetType(generalConfiguration.getCollectionProviderType()).build();
        if (Validator.isBlank((String)assetSubtypeIdentifier.getSubtypeExternalReferenceCode())) {
            return "";
        }
        if (Validator.isBlank((String)assetSubtypeIdentifier.getGroupExternalReferenceCode())) {
            return "0";
        }
        try {
            group = this._groupService.fetchGroupByExternalReferenceCode(assetSubtypeIdentifier.getGroupExternalReferenceCode(), this.sxpBlueprint.getCompanyId());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get group with external reference code " + assetSubtypeIdentifier.getGroupExternalReferenceCode()), (Throwable)exception);
            }
            return "";
        }
        String subtypeExternalReferenceCode = assetSubtypeIdentifier.getSubtypeExternalReferenceCode();
        try {
            DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.getDLFileEntryTypeByExternalReferenceCode(subtypeExternalReferenceCode, group.getGroupId());
            return String.valueOf(dlFileEntryType.getFileEntryTypeId());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get document library file entry type with external reference code " + subtypeExternalReferenceCode), (Throwable)exception);
            }
            return "";
        }
    }

    private List<FileEntry> _getDLFileEntries(SearchHits searchHits) throws PortalException {
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        for (SearchHit searchHit : searchHits.getSearchHits()) {
            Document document = searchHit.getDocument();
            fileEntries.add(this._dlAppLocalService.getFileEntry(document.getLong("entryClassPK").longValue()));
        }
        return fileEntries;
    }
}

