/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.info.collection.provider;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.util.AssetHelper;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.FilteredInfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.search.experiences.internal.info.collection.provider.SXPBlueprintInfoCollectionProvider;
import com.liferay.search.experiences.model.SXPBlueprint;
import java.util.Collections;
import java.util.List;

public class AssetEntrySXPBlueprintInfoCollectionProvider
extends SXPBlueprintInfoCollectionProvider<AssetEntry>
implements FilteredInfoCollectionProvider<AssetEntry>,
SingleFormVariationInfoCollectionProvider<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntrySXPBlueprintInfoCollectionProvider.class);

    public AssetEntrySXPBlueprintInfoCollectionProvider(AssetHelper assetHelper, Searcher searcher, SearchRequestBuilderFactory searchRequestBuilderFactory, SXPBlueprint sxpBlueprint) {
        super(assetHelper, searcher, searchRequestBuilderFactory, sxpBlueprint);
    }

    public InfoPage<AssetEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        try {
            SearchResponse searchResponse = this.getCollectionQuerySearchResponse(collectionQuery);
            return InfoPage.of((List)this.assetHelper.getAssetEntries(searchResponse.getSearchHits()), (Pagination)collectionQuery.getPagination(), (int)searchResponse.getTotalHits());
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries", (Throwable)exception);
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    @Override
    public String getKey() {
        return StringBundler.concat((Object[])new Object[]{AssetEntrySXPBlueprintInfoCollectionProvider.class.getName(), "_", this.sxpBlueprint.getCompanyId(), "_", this.sxpBlueprint.getExternalReferenceCode()});
    }
}

