/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.search.request.body.contributor;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.filter.ComplexQueryPart;
import com.liferay.portal.search.filter.ComplexQueryPartBuilder;
import com.liferay.portal.search.filter.ComplexQueryPartBuilderFactory;
import com.liferay.portal.search.rescore.Rescore;
import com.liferay.portal.search.rescore.RescoreBuilder;
import com.liferay.portal.search.rescore.RescoreBuilderFactory;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.search.experiences.blueprint.exception.InvalidQueryEntryException;
import com.liferay.search.experiences.internal.blueprint.condition.SXPConditionEvaluator;
import com.liferay.search.experiences.internal.blueprint.parameter.SXPParameterData;
import com.liferay.search.experiences.internal.blueprint.property.PropertyValidator;
import com.liferay.search.experiences.internal.blueprint.query.QueryConverter;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.SXPSearchRequestBodyContributor;
import com.liferay.search.experiences.rest.dto.v1_0.Clause;
import com.liferay.search.experiences.rest.dto.v1_0.Condition;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import com.liferay.search.experiences.rest.dto.v1_0.QueryConfiguration;
import com.liferay.search.experiences.rest.dto.v1_0.QueryEntry;
import com.liferay.search.experiences.rest.dto.v1_0.Rescore;
import java.beans.ExceptionListener;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Function;

public class QuerySXPSearchRequestBodyContributor
implements SXPSearchRequestBodyContributor {
    private final ComplexQueryPartBuilderFactory _complexQueryPartBuilderFactory;
    private final QueryConverter _queryConverter;
    private final RescoreBuilderFactory _rescoreBuilderFactory;

    public QuerySXPSearchRequestBodyContributor(ComplexQueryPartBuilderFactory complexQueryPartBuilderFactory, QueryConverter queryConverter, RescoreBuilderFactory rescoreBuilderFactory) {
        this._complexQueryPartBuilderFactory = complexQueryPartBuilderFactory;
        this._queryConverter = queryConverter;
        this._rescoreBuilderFactory = rescoreBuilderFactory;
    }

    @Override
    public void contribute(Configuration configuration, SearchRequestBuilder searchRequestBuilder, SXPParameterData sxpParameterData) {
        QueryConfiguration queryConfiguration = configuration.getQueryConfiguration();
        if (queryConfiguration == null) {
            return;
        }
        RuntimeException runtimeException = new RuntimeException();
        this._processQueryEntries(runtimeException::addSuppressed, queryConfiguration.getQueryEntries(), searchRequestBuilder, sxpParameterData);
        if (ArrayUtil.isNotEmpty((Object[])runtimeException.getSuppressed())) {
            throw runtimeException;
        }
        if (queryConfiguration.getApplyIndexerClauses() != null) {
            searchRequestBuilder.withSearchContext(searchContext -> searchContext.setAttribute("search.full.query.suppress.indexer.provided.clauses", (Serializable)Boolean.valueOf(queryConfiguration.getApplyIndexerClauses() == false)));
        }
    }

    @Override
    public String getName() {
        return "query";
    }

    private boolean _evaluate(Condition condition, RuntimeException runtimeException, SXPParameterData sxpParameterData) {
        if (condition == null) {
            return true;
        }
        try {
            SXPConditionEvaluator sxpConditionEvaluator = new SXPConditionEvaluator(sxpParameterData);
            return sxpConditionEvaluator.evaluate(PropertyValidator.validate(condition));
        }
        catch (Exception exception) {
            runtimeException.addSuppressed(exception);
            throw runtimeException;
        }
    }

    private <X, Y> void _process(Consumer<Y> consumer, ExceptionListener exceptionListener, Function<X, Y> function, X[] objects) {
        ArrayUtil.isNotEmptyForEach((Object[])objects, object -> {
            try {
                consumer.accept(function.apply(object));
            }
            catch (Exception exception) {
                exceptionListener.exceptionThrown(exception);
            }
        });
    }

    private void _processQueryEntries(ExceptionListener exceptionListener, QueryEntry[] queryEntries, SearchRequestBuilder searchRequestBuilder, SXPParameterData sxpParameterData) {
        if (ArrayUtil.isEmpty((Object[])queryEntries)) {
            return;
        }
        for (int index = 0; index < queryEntries.length; ++index) {
            try {
                this._processQueryEntry(index, queryEntries[index], searchRequestBuilder, sxpParameterData);
                continue;
            }
            catch (Exception exception) {
                exceptionListener.exceptionThrown(exception);
            }
        }
    }

    private void _processQueryEntry(int index, QueryEntry queryEntry, SearchRequestBuilder searchRequestBuilder, SXPParameterData sxpParameterData) {
        if (!GetterUtil.getBoolean((Object)queryEntry.getEnabled(), (boolean)true)) {
            return;
        }
        InvalidQueryEntryException invalidQueryEntryException = InvalidQueryEntryException.at((int)index);
        if (!this._evaluate(queryEntry.getCondition(), (RuntimeException)invalidQueryEntryException, sxpParameterData)) {
            return;
        }
        ExceptionListener exceptionListener = arg_0 -> invalidQueryEntryException.addSuppressed(arg_0);
        this._process(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addComplexQueryPart(arg_0), exceptionListener, this::_toComplexQueryPart, queryEntry.getClauses());
        this._process(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addPostFilterQueryPart(arg_0), exceptionListener, this::_toComplexQueryPart, queryEntry.getPostFilterClauses());
        this._process(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addRescore(arg_0), exceptionListener, this::_toRescore, queryEntry.getRescores());
        if (ArrayUtil.isNotEmpty((Object[])invalidQueryEntryException.getSuppressed())) {
            throw invalidQueryEntryException;
        }
    }

    private ComplexQueryPart _toComplexQueryPart(Clause clause) {
        ComplexQueryPartBuilder complexQueryPartBuilder = this._complexQueryPartBuilderFactory.builder();
        if (clause.getAdditive() != null) {
            complexQueryPartBuilder.additive(clause.getAdditive().booleanValue());
        }
        if (clause.getDisabled() != null) {
            complexQueryPartBuilder.disabled(clause.getDisabled().booleanValue());
        }
        return complexQueryPartBuilder.boost(clause.getBoost()).field(clause.getField()).name(clause.getName()).occur(clause.getOccur()).parent(clause.getParent()).query(this._queryConverter.toQuery((JSONObject)clause.getQuery())).rootClause(true).type(clause.getType()).value(clause.getValue()).build();
    }

    private com.liferay.portal.search.rescore.Rescore _toRescore(Rescore rescore) {
        RescoreBuilder rescoreBuilder = this._rescoreBuilderFactory.builder(this._queryConverter.toQuery((JSONObject)rescore.getQuery()));
        if (rescore.getScoreMode() != null) {
            rescoreBuilder.scoreMode(Rescore.ScoreMode.valueOf((String)StringUtil.toUpperCase((String)rescore.getScoreMode())));
        }
        return rescoreBuilder.queryWeight(Float.valueOf(GetterUtil.getFloat((Object)rescore.getQueryWeight()))).rescoreQueryWeight(Float.valueOf(GetterUtil.getFloat((Object)rescore.getRescoreQueryWeight()))).windowSize(Integer.valueOf(GetterUtil.getInteger((Object)rescore.getWindowSize()))).build();
    }
}

