/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.search.request.body.contributor;

import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.asset.AssetSubtypeIdentifier;
import com.liferay.portal.search.asset.AssetSubtypeIdentifierBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.search.experiences.internal.blueprint.parameter.SXPParameterData;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.SXPSearchRequestBodyContributor;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import com.liferay.search.experiences.rest.dto.v1_0.GeneralConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class GeneralSXPSearchRequestBodyContributor
implements SXPSearchRequestBodyContributor {
    private final AssetSubtypeIdentifierBuilder _assetSubtypeIdentifierBuilder;

    public GeneralSXPSearchRequestBodyContributor(AssetSubtypeIdentifierBuilder assetSubtypeIdentifierBuilder) {
        this._assetSubtypeIdentifierBuilder = assetSubtypeIdentifierBuilder;
    }

    @Override
    public void contribute(Configuration configuration, SearchRequestBuilder searchRequestBuilder, SXPParameterData sxpParameterData) {
        GeneralConfiguration generalConfiguration = configuration.getGeneralConfiguration();
        if (generalConfiguration == null) {
            return;
        }
        if (ArrayUtil.isNotEmpty((Object[])generalConfiguration.getClauseContributorsExcludes())) {
            searchRequestBuilder.withSearchContext(searchContext -> searchContext.setAttribute("search.full.query.clause.contributors.excludes", (Serializable)((Object)StringUtil.merge((Object[])generalConfiguration.getClauseContributorsExcludes()))));
        }
        if (ArrayUtil.isNotEmpty((Object[])generalConfiguration.getClauseContributorsIncludes())) {
            searchRequestBuilder.withSearchContext(searchContext -> searchContext.setAttribute("search.full.query.clause.contributors.includes", (Serializable)((Object)StringUtil.merge((Object[])generalConfiguration.getClauseContributorsIncludes()))));
        }
        if (generalConfiguration.getEmptySearchEnabled() != null) {
            searchRequestBuilder.emptySearchEnabled(generalConfiguration.getEmptySearchEnabled().booleanValue());
        }
        if (generalConfiguration.getExplain() != null) {
            searchRequestBuilder.explain(generalConfiguration.getExplain().booleanValue());
        }
        if (generalConfiguration.getIncludeResponseString() != null) {
            searchRequestBuilder.includeResponseString(generalConfiguration.getIncludeResponseString().booleanValue());
        }
        if (!Validator.isBlank((String)generalConfiguration.getQueryString())) {
            searchRequestBuilder.queryString(generalConfiguration.getQueryString());
        }
        if (ArrayUtil.isNotEmpty((Object[])generalConfiguration.getSearchableAssetTypes())) {
            String[] searchableAssetTypes = generalConfiguration.getSearchableAssetTypes();
            HashMap<String, ArrayList<AssetSubtypeIdentifier>> assetSubtypeIdentifiersMap = new HashMap<String, ArrayList<AssetSubtypeIdentifier>>();
            HashSet<String> classNamesSet = new HashSet<String>();
            for (String searchableAssetType : searchableAssetTypes) {
                AssetSubtypeIdentifier assetSubtypeIdentifier = this._assetSubtypeIdentifierBuilder.searchableAssetType(searchableAssetType).build();
                String className = assetSubtypeIdentifier.getClassName();
                classNamesSet.add(className);
                if (assetSubtypeIdentifier.getSubtypeExternalReferenceCode() == null || !FeatureFlagManagerUtil.isEnabled((String)"LPS-129412")) continue;
                ArrayList<AssetSubtypeIdentifier> assetSubtypeIdentifiers = (ArrayList<AssetSubtypeIdentifier>)assetSubtypeIdentifiersMap.get(className);
                if (assetSubtypeIdentifiers == null) {
                    assetSubtypeIdentifiers = new ArrayList<AssetSubtypeIdentifier>();
                }
                assetSubtypeIdentifiers.add(assetSubtypeIdentifier);
                assetSubtypeIdentifiersMap.put(className, assetSubtypeIdentifiers);
            }
            String[] classNames = classNamesSet.toArray(new String[0]);
            searchRequestBuilder.entryClassNames(classNames);
            searchRequestBuilder.modelIndexerClassNames(classNames);
            if (FeatureFlagManagerUtil.isEnabled((String)"LPS-129412")) {
                searchRequestBuilder.withSearchContext(searchContext -> searchContext.setAttribute("assetSubtypeIdentifiersMap", (Serializable)assetSubtypeIdentifiersMap));
            }
        }
        if (!Validator.isBlank((String)generalConfiguration.getLanguageId())) {
            searchRequestBuilder.locale(LocaleUtil.fromLanguageId((String)generalConfiguration.getLanguageId()));
        }
        if (!Validator.isBlank((String)generalConfiguration.getTimeZoneId())) {
            searchRequestBuilder.withSearchContext(searchContext -> searchContext.setTimeZone(TimeZoneUtil.getTimeZone((String)generalConfiguration.getTimeZoneId())));
        }
    }

    @Override
    public String getName() {
        return "generalConfiguration";
    }
}

