/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.search.request.body.contributor;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.collapse.CollapseBuilder;
import com.liferay.portal.search.collapse.CollapseBuilderFactory;
import com.liferay.portal.search.collapse.InnerHit;
import com.liferay.portal.search.collapse.InnerHitBuilder;
import com.liferay.portal.search.collapse.InnerHitBuilderFactory;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.search.experiences.internal.blueprint.parameter.SXPParameterData;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.SXPSearchRequestBodyContributor;
import com.liferay.search.experiences.internal.blueprint.sort.SortConverter;
import com.liferay.search.experiences.rest.dto.v1_0.AdvancedConfiguration;
import com.liferay.search.experiences.rest.dto.v1_0.Collapse;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import com.liferay.search.experiences.rest.dto.v1_0.InnerCollapse;
import com.liferay.search.experiences.rest.dto.v1_0.Source;

public class AdvancedSXPSearchRequestBodyContributor
implements SXPSearchRequestBodyContributor {
    private final CollapseBuilderFactory _collapseBuilderFactory;
    private final InnerHitBuilderFactory _innerHitBuilderFactory;
    private final SortConverter _sortConverter;

    public AdvancedSXPSearchRequestBodyContributor(CollapseBuilderFactory collapseBuilderFactory, InnerHitBuilderFactory innerHitBuilderFactory, SortConverter sortConverter) {
        this._collapseBuilderFactory = collapseBuilderFactory;
        this._innerHitBuilderFactory = innerHitBuilderFactory;
        this._sortConverter = sortConverter;
    }

    @Override
    public void contribute(Configuration configuration, SearchRequestBuilder searchRequestBuilder, SXPParameterData sxpParameterData) {
        AdvancedConfiguration advancedConfiguration = configuration.getAdvancedConfiguration();
        if (advancedConfiguration == null) {
            return;
        }
        this._setCollapse(searchRequestBuilder, advancedConfiguration.getCollapse());
        this._setFields(searchRequestBuilder, advancedConfiguration.getFields());
        this._setSourceFields(searchRequestBuilder, advancedConfiguration.getSource());
        this._setStoredFields(searchRequestBuilder, advancedConfiguration.getStored_fields());
    }

    @Override
    public String getName() {
        return "advancedConfiguration";
    }

    private void _setCollapse(SearchRequestBuilder searchRequestBuilder, Collapse collapse) {
        if (collapse == null || collapse.getField() == null) {
            return;
        }
        CollapseBuilder collapseBuilder = this._collapseBuilderFactory.builder();
        collapseBuilder.field(collapse.getField());
        if (ArrayUtil.isNotEmpty((Object[])collapse.getInnerHits())) {
            for (com.liferay.search.experiences.rest.dto.v1_0.InnerHit innerHit : collapse.getInnerHits()) {
                collapseBuilder.addInnerHit(this._translateInnerHit(innerHit));
            }
        }
        if (collapse.getMaxConcurrentGroupRequests() != null) {
            collapseBuilder.maxConcurrentGroupRequests(collapse.getMaxConcurrentGroupRequests());
        }
        searchRequestBuilder.collapse(collapseBuilder.build());
    }

    private void _setFields(SearchRequestBuilder searchRequestBuilder, String[] fields) {
        if (fields == null) {
            return;
        }
        if (fields.length == 0) {
            searchRequestBuilder.fields(new String[]{""});
        } else {
            searchRequestBuilder.fields(fields);
        }
    }

    private void _setSourceFields(SearchRequestBuilder searchRequestBuilder, Source source) {
        if (source == null) {
            return;
        }
        if (source.getExcludes() != null) {
            searchRequestBuilder.fetchSourceExcludes(source.getExcludes());
        }
        if (source.getFetchSource() != null) {
            searchRequestBuilder.fetchSource(source.getFetchSource().booleanValue());
        }
        if (source.getIncludes() != null) {
            searchRequestBuilder.fetchSourceIncludes(source.getIncludes());
        }
    }

    private void _setStoredFields(SearchRequestBuilder searchRequestBuilder, String[] storedFields) {
        if (storedFields == null) {
            return;
        }
        if (storedFields.length == 0) {
            searchRequestBuilder.storedFields(new String[]{""});
        } else {
            searchRequestBuilder.storedFields(storedFields);
        }
    }

    private InnerHit _translateInnerHit(com.liferay.search.experiences.rest.dto.v1_0.InnerHit innerHit) {
        InnerHitBuilder innerHitBuilder = this._innerHitBuilderFactory.builder();
        if (innerHit.getInnerCollapse() != null) {
            InnerCollapse innerCollapse = innerHit.getInnerCollapse();
            innerHitBuilder.innerCollapse(new com.liferay.portal.search.collapse.InnerCollapse(innerCollapse.getField()));
        }
        if (!Validator.isBlank((String)innerHit.getName())) {
            innerHitBuilder.name(innerHit.getName());
        }
        if (innerHit.getSize() != null) {
            innerHitBuilder.size(innerHit.getSize());
        }
        if (innerHit.getSorts() != null) {
            for (Object object : innerHit.getSorts()) {
                innerHitBuilder.addSort(this._sortConverter.convert(object));
            }
        }
        return innerHitBuilder.build();
    }
}

