/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.property;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.search.experiences.internal.blueprint.property.PropertyResolver;
import java.util.HashMap;
import java.util.Map;

public class PropertyExpander {
    private final PropertyResolver[] _propertyResolvers;

    public PropertyExpander(PropertyResolver ... propertyResolvers) {
        this._propertyResolvers = propertyResolvers;
    }

    public String expand(String json) {
        int index2;
        int index3;
        if (Validator.isNull((String)json) || this._propertyResolvers.length == 0) {
            return json;
        }
        int index1 = json.indexOf("${");
        if (index1 == -1) {
            return json;
        }
        StringBundler sb = new StringBundler();
        while (index1 != -1 && (index3 = json.indexOf("}", index2 = index1 + 2)) != -1) {
            int index4 = json.indexOf("|", index2);
            String name = null;
            String optionsString = null;
            if (index4 == -1 || index4 > index3) {
                name = json.substring(index2, index3);
                optionsString = null;
            } else {
                name = json.substring(index2, index4);
                optionsString = json.substring(index4 + 1, index3);
            }
            Object value = this._resolve(name, this._getOptions(optionsString));
            if (value != null) {
                json = this._replace(json, json.substring(index1, index3 + 1), value);
            } else {
                sb.append(json.substring(0, index3 + 1));
                json = json.substring(index3 + 1);
            }
            index1 = json.indexOf("${");
        }
        if (sb.index() == 0) {
            return json;
        }
        sb.append(json);
        return sb.toString();
    }

    private Map<String, String> _getOptions(String optionsString) {
        if (Validator.isNull((String)optionsString)) {
            return null;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (String string : optionsString.split(",")) {
            String[] array = string.split("=");
            if (array.length == 1) {
                options.put(array[0], null);
                continue;
            }
            options.put(array[0], array[1]);
        }
        return options;
    }

    private String _replace(String json, String placeholder, Object value) {
        String valueString = value.toString();
        if (value instanceof JSONObject || valueString.startsWith("[")) {
            placeholder = StringUtil.quote((String)placeholder, (char)'\"');
        }
        return StringUtil.replace((String)json, (String)placeholder, (String)valueString);
    }

    private Object _resolve(String name, Map<String, String> options) {
        for (PropertyResolver propertyResolver : this._propertyResolvers) {
            Object value = propertyResolver.resolve(name, options);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

